package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait InventorySchemaDeleteOption {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.InventorySchemaDeleteOption
}
object InventorySchemaDeleteOption {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.InventorySchemaDeleteOption
  ): zio.aws.ssm.model.InventorySchemaDeleteOption = value match {
    case software.amazon.awssdk.services.ssm.model.InventorySchemaDeleteOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.InventorySchemaDeleteOption.DISABLE_SCHEMA =>
      val r = DisableSchema
      r
    case software.amazon.awssdk.services.ssm.model.InventorySchemaDeleteOption.DELETE_SCHEMA =>
      val r = DeleteSchema
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.InventorySchemaDeleteOption {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventorySchemaDeleteOption =
      software.amazon.awssdk.services.ssm.model.InventorySchemaDeleteOption.UNKNOWN_TO_SDK_VERSION
  }
  case object DisableSchema
      extends zio.aws.ssm.model.InventorySchemaDeleteOption {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventorySchemaDeleteOption =
      software.amazon.awssdk.services.ssm.model.InventorySchemaDeleteOption.DISABLE_SCHEMA
  }
  case object DeleteSchema
      extends zio.aws.ssm.model.InventorySchemaDeleteOption {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventorySchemaDeleteOption =
      software.amazon.awssdk.services.ssm.model.InventorySchemaDeleteOption.DELETE_SCHEMA
  }
}
