package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PSParameterVersion
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutParameterResponse(
    version: Optional[PSParameterVersion] = Optional.Absent,
    tier: Optional[zio.aws.ssm.model.ParameterTier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.PutParameterResponse = {
    import PutParameterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PutParameterResponse
      .builder()
      .optionallyWith(
        version.map(value => PSParameterVersion.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PutParameterResponse.ReadOnly =
    zio.aws.ssm.model.PutParameterResponse.wrap(buildAwsValue())
}
object PutParameterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.PutParameterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PutParameterResponse =
      zio.aws.ssm.model.PutParameterResponse(
        version.map(value => value),
        tier.map(value => value)
      )
    def version: Optional[PSParameterVersion]
    def tier: Optional[zio.aws.ssm.model.ParameterTier]
    def getVersion: ZIO[Any, AwsError, PSParameterVersion] =
      AwsError.unwrapOptionField("version", version)
    def getTier: ZIO[Any, AwsError, zio.aws.ssm.model.ParameterTier] =
      AwsError.unwrapOptionField("tier", tier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PutParameterResponse
  ) extends zio.aws.ssm.model.PutParameterResponse.ReadOnly {
    override val version: Optional[PSParameterVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.ssm.model.primitives.PSParameterVersion(value))
    override val tier: Optional[zio.aws.ssm.model.ParameterTier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tier())
        .map(value => zio.aws.ssm.model.ParameterTier.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PutParameterResponse
  ): zio.aws.ssm.model.PutParameterResponse.ReadOnly = new Wrapper(impl)
}
