package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait RebootOption {
  def unwrap: software.amazon.awssdk.services.ssm.model.RebootOption
}
object RebootOption {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.RebootOption
  ): zio.aws.ssm.model.RebootOption = value match {
    case software.amazon.awssdk.services.ssm.model.RebootOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.RebootOption.REBOOT_IF_NEEDED =>
      val r = RebootIfNeeded
      r
    case software.amazon.awssdk.services.ssm.model.RebootOption.NO_REBOOT =>
      val r = NoReboot
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.RebootOption {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.RebootOption =
      software.amazon.awssdk.services.ssm.model.RebootOption.UNKNOWN_TO_SDK_VERSION
  }
  case object RebootIfNeeded extends zio.aws.ssm.model.RebootOption {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.RebootOption =
      software.amazon.awssdk.services.ssm.model.RebootOption.REBOOT_IF_NEEDED
  }
  case object NoReboot extends zio.aws.ssm.model.RebootOption {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.RebootOption =
      software.amazon.awssdk.services.ssm.model.RebootOption.NO_REBOOT
  }
}
