package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.Url
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3OutputUrl(outputUrl: Optional[Url] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.S3OutputUrl = {
    import S3OutputUrl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.S3OutputUrl
      .builder()
      .optionallyWith(
        outputUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.outputUrl)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.S3OutputUrl.ReadOnly =
    zio.aws.ssm.model.S3OutputUrl.wrap(buildAwsValue())
}
object S3OutputUrl {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.S3OutputUrl] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.S3OutputUrl =
      zio.aws.ssm.model.S3OutputUrl(outputUrl.map(value => value))
    def outputUrl: Optional[Url]
    def getOutputUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("outputUrl", outputUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.S3OutputUrl
  ) extends zio.aws.ssm.model.S3OutputUrl.ReadOnly {
    override val outputUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.outputUrl())
      .map(value => zio.aws.ssm.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.S3OutputUrl
  ): zio.aws.ssm.model.S3OutputUrl.ReadOnly = new Wrapper(impl)
}
