package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  DateTime,
  ServiceSettingValue,
  ServiceSettingId
}
import scala.jdk.CollectionConverters.*
final case class ServiceSetting(
    settingId: Optional[ServiceSettingId] = Optional.Absent,
    settingValue: Optional[ServiceSettingValue] = Optional.Absent,
    lastModifiedDate: Optional[DateTime] = Optional.Absent,
    lastModifiedUser: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ServiceSetting = {
    import ServiceSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ServiceSetting
      .builder()
      .optionallyWith(
        settingId.map(value => ServiceSettingId.unwrap(value): java.lang.String)
      )(_.settingId)
      .optionallyWith(
        settingValue.map(value =>
          ServiceSettingValue.unwrap(value): java.lang.String
        )
      )(_.settingValue)
      .optionallyWith(
        lastModifiedDate.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(lastModifiedUser.map(value => value: java.lang.String))(
        _.lastModifiedUser
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ServiceSetting.ReadOnly =
    zio.aws.ssm.model.ServiceSetting.wrap(buildAwsValue())
}
object ServiceSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ServiceSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ServiceSetting =
      zio.aws.ssm.model.ServiceSetting(
        settingId.map(value => value),
        settingValue.map(value => value),
        lastModifiedDate.map(value => value),
        lastModifiedUser.map(value => value),
        arn.map(value => value),
        status.map(value => value)
      )
    def settingId: Optional[ServiceSettingId]
    def settingValue: Optional[ServiceSettingValue]
    def lastModifiedDate: Optional[DateTime]
    def lastModifiedUser: Optional[String]
    def arn: Optional[String]
    def status: Optional[String]
    def getSettingId: ZIO[Any, AwsError, ServiceSettingId] =
      AwsError.unwrapOptionField("settingId", settingId)
    def getSettingValue: ZIO[Any, AwsError, ServiceSettingValue] =
      AwsError.unwrapOptionField("settingValue", settingValue)
    def getLastModifiedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLastModifiedUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastModifiedUser", lastModifiedUser)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ServiceSetting
  ) extends zio.aws.ssm.model.ServiceSetting.ReadOnly {
    override val settingId: Optional[ServiceSettingId] = zio.aws.core.internal
      .optionalFromNullable(impl.settingId())
      .map(value => zio.aws.ssm.model.primitives.ServiceSettingId(value))
    override val settingValue: Optional[ServiceSettingValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settingValue())
        .map(value => zio.aws.ssm.model.primitives.ServiceSettingValue(value))
    override val lastModifiedDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastModifiedUser: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedUser())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ServiceSetting
  ): zio.aws.ssm.model.ServiceSetting.ReadOnly = new Wrapper(impl)
}
