package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  OpsItemId,
  DateTime,
  OpsItemPriority,
  OpsItemSeverity,
  OpsItemDataKey,
  OpsItemDescription,
  OpsItemTitle,
  OpsItemCategory
}
import scala.jdk.CollectionConverters.*
final case class UpdateOpsItemRequest(
    description: Optional[OpsItemDescription] = Optional.Absent,
    operationalData: Optional[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue]
    ] = Optional.Absent,
    operationalDataToDelete: Optional[Iterable[String]] = Optional.Absent,
    notifications: Optional[Iterable[zio.aws.ssm.model.OpsItemNotification]] =
      Optional.Absent,
    priority: Optional[OpsItemPriority] = Optional.Absent,
    relatedOpsItems: Optional[Iterable[zio.aws.ssm.model.RelatedOpsItem]] =
      Optional.Absent,
    status: Optional[zio.aws.ssm.model.OpsItemStatus] = Optional.Absent,
    opsItemId: OpsItemId,
    title: Optional[OpsItemTitle] = Optional.Absent,
    category: Optional[OpsItemCategory] = Optional.Absent,
    severity: Optional[OpsItemSeverity] = Optional.Absent,
    actualStartTime: Optional[DateTime] = Optional.Absent,
    actualEndTime: Optional[DateTime] = Optional.Absent,
    plannedStartTime: Optional[DateTime] = Optional.Absent,
    plannedEndTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest = {
    import UpdateOpsItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          OpsItemDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        operationalData.map(value =>
          value
            .map({ case (key, value) =>
              (OpsItemDataKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.operationalData)
      .optionallyWith(
        operationalDataToDelete.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.operationalDataToDelete)
      .optionallyWith(
        notifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notifications)
      .optionallyWith(
        priority.map(value => OpsItemPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(
        relatedOpsItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedOpsItems)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .opsItemId(OpsItemId.unwrap(opsItemId): java.lang.String)
      .optionallyWith(
        title.map(value => OpsItemTitle.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        category.map(value => OpsItemCategory.unwrap(value): java.lang.String)
      )(_.category)
      .optionallyWith(
        severity.map(value => OpsItemSeverity.unwrap(value): java.lang.String)
      )(_.severity)
      .optionallyWith(
        actualStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualStartTime)
      .optionallyWith(
        actualEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualEndTime)
      .optionallyWith(
        plannedStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedStartTime)
      .optionallyWith(
        plannedEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedEndTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateOpsItemRequest.ReadOnly =
    zio.aws.ssm.model.UpdateOpsItemRequest.wrap(buildAwsValue())
}
object UpdateOpsItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateOpsItemRequest =
      zio.aws.ssm.model.UpdateOpsItemRequest(
        description.map(value => value),
        operationalData.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        operationalDataToDelete.map(value => value),
        notifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        priority.map(value => value),
        relatedOpsItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        opsItemId,
        title.map(value => value),
        category.map(value => value),
        severity.map(value => value),
        actualStartTime.map(value => value),
        actualEndTime.map(value => value),
        plannedStartTime.map(value => value),
        plannedEndTime.map(value => value)
      )
    def description: Optional[OpsItemDescription]
    def operationalData: Optional[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ]
    def operationalDataToDelete: Optional[List[String]]
    def notifications
        : Optional[List[zio.aws.ssm.model.OpsItemNotification.ReadOnly]]
    def priority: Optional[OpsItemPriority]
    def relatedOpsItems
        : Optional[List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]]
    def status: Optional[zio.aws.ssm.model.OpsItemStatus]
    def opsItemId: OpsItemId
    def title: Optional[OpsItemTitle]
    def category: Optional[OpsItemCategory]
    def severity: Optional[OpsItemSeverity]
    def actualStartTime: Optional[DateTime]
    def actualEndTime: Optional[DateTime]
    def plannedStartTime: Optional[DateTime]
    def plannedEndTime: Optional[DateTime]
    def getDescription: ZIO[Any, AwsError, OpsItemDescription] =
      AwsError.unwrapOptionField("description", description)
    def getOperationalData: ZIO[Any, AwsError, Map[
      OpsItemDataKey,
      zio.aws.ssm.model.OpsItemDataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("operationalData", operationalData)
    def getOperationalDataToDelete: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("operationalDataToDelete", operationalDataToDelete)
    def getNotifications: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.OpsItemNotification.ReadOnly
    ]] = AwsError.unwrapOptionField("notifications", notifications)
    def getPriority: ZIO[Any, AwsError, OpsItemPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getRelatedOpsItems
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]] =
      AwsError.unwrapOptionField("relatedOpsItems", relatedOpsItems)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.OpsItemStatus] =
      AwsError.unwrapOptionField("status", status)
    def getOpsItemId: ZIO[Any, Nothing, OpsItemId] = ZIO.succeed(opsItemId)
    def getTitle: ZIO[Any, AwsError, OpsItemTitle] =
      AwsError.unwrapOptionField("title", title)
    def getCategory: ZIO[Any, AwsError, OpsItemCategory] =
      AwsError.unwrapOptionField("category", category)
    def getSeverity: ZIO[Any, AwsError, OpsItemSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getActualStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualStartTime", actualStartTime)
    def getActualEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualEndTime", actualEndTime)
    def getPlannedStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedStartTime", plannedStartTime)
    def getPlannedEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedEndTime", plannedEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest
  ) extends zio.aws.ssm.model.UpdateOpsItemRequest.ReadOnly {
    override val description: Optional[OpsItemDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.ssm.model.primitives.OpsItemDescription(value))
    override val operationalData: Optional[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.operationalData())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.OpsItemDataKey(
              key
            ) -> zio.aws.ssm.model.OpsItemDataValue.wrap(value)
          })
          .toMap
      )
    override val operationalDataToDelete: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationalDataToDelete())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val notifications
        : Optional[List[zio.aws.ssm.model.OpsItemNotification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsItemNotification.wrap(item)
          }.toList
        )
    override val priority: Optional[OpsItemPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.ssm.model.primitives.OpsItemPriority(value))
    override val relatedOpsItems
        : Optional[List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedOpsItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.RelatedOpsItem.wrap(item)
          }.toList
        )
    override val status: Optional[zio.aws.ssm.model.OpsItemStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssm.model.OpsItemStatus.wrap(value))
    override val opsItemId: OpsItemId =
      zio.aws.ssm.model.primitives.OpsItemId(impl.opsItemId())
    override val title: Optional[OpsItemTitle] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.ssm.model.primitives.OpsItemTitle(value))
    override val category: Optional[OpsItemCategory] = zio.aws.core.internal
      .optionalFromNullable(impl.category())
      .map(value => zio.aws.ssm.model.primitives.OpsItemCategory(value))
    override val severity: Optional[OpsItemSeverity] = zio.aws.core.internal
      .optionalFromNullable(impl.severity())
      .map(value => zio.aws.ssm.model.primitives.OpsItemSeverity(value))
    override val actualStartTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.actualStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val actualEndTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.actualEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedStartTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.plannedStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedEndTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.plannedEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest
  ): zio.aws.ssm.model.UpdateOpsItemRequest.ReadOnly = new Wrapper(impl)
}
