package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AddTagsToResourceRequest(
    resourceType: zio.aws.ssm.model.ResourceTypeForTagging,
    resourceId: ResourceId,
    tags: Iterable[zio.aws.ssm.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AddTagsToResourceRequest = {
    import AddTagsToResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AddTagsToResourceRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AddTagsToResourceRequest.ReadOnly =
    zio.aws.ssm.model.AddTagsToResourceRequest.wrap(buildAwsValue())
}
object AddTagsToResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AddTagsToResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AddTagsToResourceRequest =
      zio.aws.ssm.model.AddTagsToResourceRequest(
        resourceType,
        resourceId,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceType: zio.aws.ssm.model.ResourceTypeForTagging
    def resourceId: ResourceId
    def tags: List[zio.aws.ssm.model.Tag.ReadOnly]
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.ssm.model.ResourceTypeForTagging] =
      ZIO.succeed(resourceType)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getTags: ZIO[Any, Nothing, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AddTagsToResourceRequest
  ) extends zio.aws.ssm.model.AddTagsToResourceRequest.ReadOnly {
    override val resourceType: zio.aws.ssm.model.ResourceTypeForTagging =
      zio.aws.ssm.model.ResourceTypeForTagging.wrap(impl.resourceType())
    override val resourceId: ResourceId =
      zio.aws.ssm.model.primitives.ResourceId(impl.resourceId())
    override val tags: List[zio.aws.ssm.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.ssm.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AddTagsToResourceRequest
  ): zio.aws.ssm.model.AddTagsToResourceRequest.ReadOnly = new Wrapper(impl)
}
