package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.AlarmName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Alarm(name: AlarmName) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.Alarm = {
    import Alarm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.Alarm
      .builder()
      .name(AlarmName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.Alarm.ReadOnly =
    zio.aws.ssm.model.Alarm.wrap(buildAwsValue())
}
object Alarm {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.Alarm] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.Alarm = zio.aws.ssm.model.Alarm(name)
    def name: AlarmName
    def getName: ZIO[Any, Nothing, AlarmName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.Alarm
  ) extends zio.aws.ssm.model.Alarm.ReadOnly {
    override val name: AlarmName =
      zio.aws.ssm.model.primitives.AlarmName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.Alarm
  ): zio.aws.ssm.model.Alarm.ReadOnly = new Wrapper(impl)
}
