package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait AssociationFilterKey {
  def unwrap: software.amazon.awssdk.services.ssm.model.AssociationFilterKey
}
object AssociationFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.AssociationFilterKey
  ): zio.aws.ssm.model.AssociationFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.AssociationFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.AssociationFilterKey.INSTANCE_ID =>
      val r = InstanceId
      r
    case software.amazon.awssdk.services.ssm.model.AssociationFilterKey.NAME =>
      val r = Name
      r
    case software.amazon.awssdk.services.ssm.model.AssociationFilterKey.ASSOCIATION_ID =>
      val r = AssociationId
      r
    case software.amazon.awssdk.services.ssm.model.AssociationFilterKey.ASSOCIATION_STATUS_NAME =>
      val r = AssociationStatusName
      r
    case software.amazon.awssdk.services.ssm.model.AssociationFilterKey.LAST_EXECUTED_BEFORE =>
      val r = LastExecutedBefore
      r
    case software.amazon.awssdk.services.ssm.model.AssociationFilterKey.LAST_EXECUTED_AFTER =>
      val r = LastExecutedAfter
      r
    case software.amazon.awssdk.services.ssm.model.AssociationFilterKey.ASSOCIATION_NAME =>
      val r = AssociationName
      r
    case software.amazon.awssdk.services.ssm.model.AssociationFilterKey.RESOURCE_GROUP_NAME =>
      val r = ResourceGroupName
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.AssociationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object InstanceId extends zio.aws.ssm.model.AssociationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationFilterKey.INSTANCE_ID
  }
  case object Name extends zio.aws.ssm.model.AssociationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationFilterKey.NAME
  }
  case object AssociationId extends zio.aws.ssm.model.AssociationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationFilterKey.ASSOCIATION_ID
  }
  case object AssociationStatusName
      extends zio.aws.ssm.model.AssociationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationFilterKey.ASSOCIATION_STATUS_NAME
  }
  case object LastExecutedBefore
      extends zio.aws.ssm.model.AssociationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationFilterKey.LAST_EXECUTED_BEFORE
  }
  case object LastExecutedAfter extends zio.aws.ssm.model.AssociationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationFilterKey.LAST_EXECUTED_AFTER
  }
  case object AssociationName extends zio.aws.ssm.model.AssociationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationFilterKey.ASSOCIATION_NAME
  }
  case object ResourceGroupName extends zio.aws.ssm.model.AssociationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationFilterKey.RESOURCE_GROUP_NAME
  }
}
