package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait AssociationFilterOperatorType {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.AssociationFilterOperatorType
}
object AssociationFilterOperatorType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.AssociationFilterOperatorType
  ): zio.aws.ssm.model.AssociationFilterOperatorType = value match {
    case software.amazon.awssdk.services.ssm.model.AssociationFilterOperatorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.AssociationFilterOperatorType.EQUAL =>
      val r = EQUAL
      r
    case software.amazon.awssdk.services.ssm.model.AssociationFilterOperatorType.LESS_THAN =>
      val r = LESS_THAN
      r
    case software.amazon.awssdk.services.ssm.model.AssociationFilterOperatorType.GREATER_THAN =>
      val r = GREATER_THAN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.AssociationFilterOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationFilterOperatorType =
      software.amazon.awssdk.services.ssm.model.AssociationFilterOperatorType.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUAL extends zio.aws.ssm.model.AssociationFilterOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationFilterOperatorType =
      software.amazon.awssdk.services.ssm.model.AssociationFilterOperatorType.EQUAL
  }
  case object LESS_THAN
      extends zio.aws.ssm.model.AssociationFilterOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationFilterOperatorType =
      software.amazon.awssdk.services.ssm.model.AssociationFilterOperatorType.LESS_THAN
  }
  case object GREATER_THAN
      extends zio.aws.ssm.model.AssociationFilterOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationFilterOperatorType =
      software.amazon.awssdk.services.ssm.model.AssociationFilterOperatorType.GREATER_THAN
  }
}
