package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  CloudWatchOutputEnabled,
  CloudWatchLogGroupName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CloudWatchOutputConfig(
    cloudWatchLogGroupName: Optional[CloudWatchLogGroupName] = Optional.Absent,
    cloudWatchOutputEnabled: Optional[CloudWatchOutputEnabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CloudWatchOutputConfig = {
    import CloudWatchOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CloudWatchOutputConfig
      .builder()
      .optionallyWith(
        cloudWatchLogGroupName.map(value =>
          CloudWatchLogGroupName.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupName)
      .optionallyWith(
        cloudWatchOutputEnabled.map(value =>
          CloudWatchOutputEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.cloudWatchOutputEnabled)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly =
    zio.aws.ssm.model.CloudWatchOutputConfig.wrap(buildAwsValue())
}
object CloudWatchOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CloudWatchOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CloudWatchOutputConfig =
      zio.aws.ssm.model.CloudWatchOutputConfig(
        cloudWatchLogGroupName.map(value => value),
        cloudWatchOutputEnabled.map(value => value)
      )
    def cloudWatchLogGroupName: Optional[CloudWatchLogGroupName]
    def cloudWatchOutputEnabled: Optional[CloudWatchOutputEnabled]
    def getCloudWatchLogGroupName: ZIO[Any, AwsError, CloudWatchLogGroupName] =
      AwsError.unwrapOptionField(
        "cloudWatchLogGroupName",
        cloudWatchLogGroupName
      )
    def getCloudWatchOutputEnabled
        : ZIO[Any, AwsError, CloudWatchOutputEnabled] = AwsError
      .unwrapOptionField("cloudWatchOutputEnabled", cloudWatchOutputEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CloudWatchOutputConfig
  ) extends zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly {
    override val cloudWatchLogGroupName: Optional[CloudWatchLogGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogGroupName())
        .map(value =>
          zio.aws.ssm.model.primitives.CloudWatchLogGroupName(value)
        )
    override val cloudWatchOutputEnabled: Optional[CloudWatchOutputEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchOutputEnabled())
        .map(value =>
          zio.aws.ssm.model.primitives.CloudWatchOutputEnabled(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CloudWatchOutputConfig
  ): zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly = new Wrapper(impl)
}
