package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  Url,
  S3Region,
  CommandPluginOutput,
  S3KeyPrefix,
  ResponseCode,
  DateTime,
  S3BucketName,
  CommandPluginName,
  StatusDetails
}
import scala.jdk.CollectionConverters.*
final case class CommandPlugin(
    name: Optional[CommandPluginName] = Optional.Absent,
    status: Optional[zio.aws.ssm.model.CommandPluginStatus] = Optional.Absent,
    statusDetails: Optional[StatusDetails] = Optional.Absent,
    responseCode: Optional[ResponseCode] = Optional.Absent,
    responseStartDateTime: Optional[DateTime] = Optional.Absent,
    responseFinishDateTime: Optional[DateTime] = Optional.Absent,
    output: Optional[CommandPluginOutput] = Optional.Absent,
    standardOutputUrl: Optional[Url] = Optional.Absent,
    standardErrorUrl: Optional[Url] = Optional.Absent,
    outputS3Region: Optional[S3Region] = Optional.Absent,
    outputS3BucketName: Optional[S3BucketName] = Optional.Absent,
    outputS3KeyPrefix: Optional[S3KeyPrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CommandPlugin = {
    import CommandPlugin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CommandPlugin
      .builder()
      .optionallyWith(
        name.map(value => CommandPluginName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          StatusDetails.unwrap(value): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(
        responseCode.map(value => ResponseCode.unwrap(value): Integer)
      )(_.responseCode)
      .optionallyWith(
        responseStartDateTime.map(value => DateTime.unwrap(value): Instant)
      )(_.responseStartDateTime)
      .optionallyWith(
        responseFinishDateTime.map(value => DateTime.unwrap(value): Instant)
      )(_.responseFinishDateTime)
      .optionallyWith(
        output.map(value => CommandPluginOutput.unwrap(value): java.lang.String)
      )(_.output)
      .optionallyWith(
        standardOutputUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.standardOutputUrl)
      .optionallyWith(
        standardErrorUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.standardErrorUrl)
      .optionallyWith(
        outputS3Region.map(value => S3Region.unwrap(value): java.lang.String)
      )(_.outputS3Region)
      .optionallyWith(
        outputS3BucketName.map(value =>
          S3BucketName.unwrap(value): java.lang.String
        )
      )(_.outputS3BucketName)
      .optionallyWith(
        outputS3KeyPrefix.map(value =>
          S3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.outputS3KeyPrefix)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CommandPlugin.ReadOnly =
    zio.aws.ssm.model.CommandPlugin.wrap(buildAwsValue())
}
object CommandPlugin {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.CommandPlugin] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CommandPlugin =
      zio.aws.ssm.model.CommandPlugin(
        name.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        responseCode.map(value => value),
        responseStartDateTime.map(value => value),
        responseFinishDateTime.map(value => value),
        output.map(value => value),
        standardOutputUrl.map(value => value),
        standardErrorUrl.map(value => value),
        outputS3Region.map(value => value),
        outputS3BucketName.map(value => value),
        outputS3KeyPrefix.map(value => value)
      )
    def name: Optional[CommandPluginName]
    def status: Optional[zio.aws.ssm.model.CommandPluginStatus]
    def statusDetails: Optional[StatusDetails]
    def responseCode: Optional[ResponseCode]
    def responseStartDateTime: Optional[DateTime]
    def responseFinishDateTime: Optional[DateTime]
    def output: Optional[CommandPluginOutput]
    def standardOutputUrl: Optional[Url]
    def standardErrorUrl: Optional[Url]
    def outputS3Region: Optional[S3Region]
    def outputS3BucketName: Optional[S3BucketName]
    def outputS3KeyPrefix: Optional[S3KeyPrefix]
    def getName: ZIO[Any, AwsError, CommandPluginName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.CommandPluginStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDetails: ZIO[Any, AwsError, StatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getResponseCode: ZIO[Any, AwsError, ResponseCode] =
      AwsError.unwrapOptionField("responseCode", responseCode)
    def getResponseStartDateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("responseStartDateTime", responseStartDateTime)
    def getResponseFinishDateTime: ZIO[Any, AwsError, DateTime] = AwsError
      .unwrapOptionField("responseFinishDateTime", responseFinishDateTime)
    def getOutput: ZIO[Any, AwsError, CommandPluginOutput] =
      AwsError.unwrapOptionField("output", output)
    def getStandardOutputUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("standardOutputUrl", standardOutputUrl)
    def getStandardErrorUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("standardErrorUrl", standardErrorUrl)
    def getOutputS3Region: ZIO[Any, AwsError, S3Region] =
      AwsError.unwrapOptionField("outputS3Region", outputS3Region)
    def getOutputS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("outputS3BucketName", outputS3BucketName)
    def getOutputS3KeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("outputS3KeyPrefix", outputS3KeyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CommandPlugin
  ) extends zio.aws.ssm.model.CommandPlugin.ReadOnly {
    override val name: Optional[CommandPluginName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.CommandPluginName(value))
    override val status: Optional[zio.aws.ssm.model.CommandPluginStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssm.model.CommandPluginStatus.wrap(value))
    override val statusDetails: Optional[StatusDetails] = zio.aws.core.internal
      .optionalFromNullable(impl.statusDetails())
      .map(value => zio.aws.ssm.model.primitives.StatusDetails(value))
    override val responseCode: Optional[ResponseCode] = zio.aws.core.internal
      .optionalFromNullable(impl.responseCode())
      .map(value => zio.aws.ssm.model.primitives.ResponseCode(value))
    override val responseStartDateTime: Optional[DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseStartDateTime())
        .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val responseFinishDateTime: Optional[DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseFinishDateTime())
        .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val output: Optional[CommandPluginOutput] = zio.aws.core.internal
      .optionalFromNullable(impl.output())
      .map(value => zio.aws.ssm.model.primitives.CommandPluginOutput(value))
    override val standardOutputUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.standardOutputUrl())
      .map(value => zio.aws.ssm.model.primitives.Url(value))
    override val standardErrorUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.standardErrorUrl())
      .map(value => zio.aws.ssm.model.primitives.Url(value))
    override val outputS3Region: Optional[S3Region] = zio.aws.core.internal
      .optionalFromNullable(impl.outputS3Region())
      .map(value => zio.aws.ssm.model.primitives.S3Region(value))
    override val outputS3BucketName: Optional[S3BucketName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputS3BucketName())
        .map(value => zio.aws.ssm.model.primitives.S3BucketName(value))
    override val outputS3KeyPrefix: Optional[S3KeyPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputS3KeyPrefix())
        .map(value => zio.aws.ssm.model.primitives.S3KeyPrefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CommandPlugin
  ): zio.aws.ssm.model.CommandPlugin.ReadOnly = new Wrapper(impl)
}
