package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait CommandStatus {
  def unwrap: software.amazon.awssdk.services.ssm.model.CommandStatus
}
object CommandStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.CommandStatus
  ): zio.aws.ssm.model.CommandStatus = value match {
    case software.amazon.awssdk.services.ssm.model.CommandStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.CommandStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.ssm.model.CommandStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.ssm.model.CommandStatus.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.ssm.model.CommandStatus.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.ssm.model.CommandStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.ssm.model.CommandStatus.TIMED_OUT =>
      val r = TimedOut
      r
    case software.amazon.awssdk.services.ssm.model.CommandStatus.CANCELLING =>
      val r = Cancelling
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.CommandStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandStatus =
      software.amazon.awssdk.services.ssm.model.CommandStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.ssm.model.CommandStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandStatus =
      software.amazon.awssdk.services.ssm.model.CommandStatus.PENDING
  }
  case object InProgress extends zio.aws.ssm.model.CommandStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandStatus =
      software.amazon.awssdk.services.ssm.model.CommandStatus.IN_PROGRESS
  }
  case object Success extends zio.aws.ssm.model.CommandStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandStatus =
      software.amazon.awssdk.services.ssm.model.CommandStatus.SUCCESS
  }
  case object Cancelled extends zio.aws.ssm.model.CommandStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandStatus =
      software.amazon.awssdk.services.ssm.model.CommandStatus.CANCELLED
  }
  case object Failed extends zio.aws.ssm.model.CommandStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandStatus =
      software.amazon.awssdk.services.ssm.model.CommandStatus.FAILED
  }
  case object TimedOut extends zio.aws.ssm.model.CommandStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandStatus =
      software.amazon.awssdk.services.ssm.model.CommandStatus.TIMED_OUT
  }
  case object Cancelling extends zio.aws.ssm.model.CommandStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandStatus =
      software.amazon.awssdk.services.ssm.model.CommandStatus.CANCELLING
  }
}
