package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  ComplianceExecutionType,
  ComplianceExecutionId,
  DateTime
}
import scala.jdk.CollectionConverters.*
final case class ComplianceExecutionSummary(
    executionTime: DateTime,
    executionId: Optional[ComplianceExecutionId] = Optional.Absent,
    executionType: Optional[ComplianceExecutionType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ComplianceExecutionSummary = {
    import ComplianceExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ComplianceExecutionSummary
      .builder()
      .executionTime(DateTime.unwrap(executionTime): Instant)
      .optionallyWith(
        executionId.map(value =>
          ComplianceExecutionId.unwrap(value): java.lang.String
        )
      )(_.executionId)
      .optionallyWith(
        executionType.map(value =>
          ComplianceExecutionType.unwrap(value): java.lang.String
        )
      )(_.executionType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly =
    zio.aws.ssm.model.ComplianceExecutionSummary.wrap(buildAwsValue())
}
object ComplianceExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ComplianceExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ComplianceExecutionSummary =
      zio.aws.ssm.model.ComplianceExecutionSummary(
        executionTime,
        executionId.map(value => value),
        executionType.map(value => value)
      )
    def executionTime: DateTime
    def executionId: Optional[ComplianceExecutionId]
    def executionType: Optional[ComplianceExecutionType]
    def getExecutionTime: ZIO[Any, Nothing, DateTime] =
      ZIO.succeed(executionTime)
    def getExecutionId: ZIO[Any, AwsError, ComplianceExecutionId] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getExecutionType: ZIO[Any, AwsError, ComplianceExecutionType] =
      AwsError.unwrapOptionField("executionType", executionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ComplianceExecutionSummary
  ) extends zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly {
    override val executionTime: DateTime =
      zio.aws.ssm.model.primitives.DateTime(impl.executionTime())
    override val executionId: Optional[ComplianceExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionId())
        .map(value => zio.aws.ssm.model.primitives.ComplianceExecutionId(value))
    override val executionType: Optional[ComplianceExecutionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionType())
        .map(value =>
          zio.aws.ssm.model.primitives.ComplianceExecutionType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ComplianceExecutionSummary
  ): zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly = new Wrapper(impl)
}
