package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.ComplianceSummaryCount
import scala.jdk.CollectionConverters.*
final case class CompliantSummary(
    compliantCount: Optional[ComplianceSummaryCount] = Optional.Absent,
    severitySummary: Optional[zio.aws.ssm.model.SeveritySummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CompliantSummary = {
    import CompliantSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CompliantSummary
      .builder()
      .optionallyWith(
        compliantCount.map(value =>
          ComplianceSummaryCount.unwrap(value): Integer
        )
      )(_.compliantCount)
      .optionallyWith(severitySummary.map(value => value.buildAwsValue()))(
        _.severitySummary
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CompliantSummary.ReadOnly =
    zio.aws.ssm.model.CompliantSummary.wrap(buildAwsValue())
}
object CompliantSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CompliantSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CompliantSummary =
      zio.aws.ssm.model.CompliantSummary(
        compliantCount.map(value => value),
        severitySummary.map(value => value.asEditable)
      )
    def compliantCount: Optional[ComplianceSummaryCount]
    def severitySummary: Optional[zio.aws.ssm.model.SeveritySummary.ReadOnly]
    def getCompliantCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("compliantCount", compliantCount)
    def getSeveritySummary
        : ZIO[Any, AwsError, zio.aws.ssm.model.SeveritySummary.ReadOnly] =
      AwsError.unwrapOptionField("severitySummary", severitySummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CompliantSummary
  ) extends zio.aws.ssm.model.CompliantSummary.ReadOnly {
    override val compliantCount: Optional[ComplianceSummaryCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compliantCount())
        .map(value =>
          zio.aws.ssm.model.primitives.ComplianceSummaryCount(value)
        )
    override val severitySummary
        : Optional[zio.aws.ssm.model.SeveritySummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severitySummary())
        .map(value => zio.aws.ssm.model.SeveritySummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CompliantSummary
  ): zio.aws.ssm.model.CompliantSummary.ReadOnly = new Wrapper(impl)
}
