package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  IamRole,
  RegistrationLimit,
  DefaultInstanceName,
  ExpirationDate,
  ActivationDescription
}
import scala.jdk.CollectionConverters.*
final case class CreateActivationRequest(
    description: Optional[ActivationDescription] = Optional.Absent,
    defaultInstanceName: Optional[DefaultInstanceName] = Optional.Absent,
    iamRole: IamRole,
    registrationLimit: Optional[RegistrationLimit] = Optional.Absent,
    expirationDate: Optional[ExpirationDate] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ssm.model.Tag]] = Optional.Absent,
    registrationMetadata: Optional[
      Iterable[zio.aws.ssm.model.RegistrationMetadataItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateActivationRequest = {
    import CreateActivationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateActivationRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          ActivationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        defaultInstanceName.map(value =>
          DefaultInstanceName.unwrap(value): java.lang.String
        )
      )(_.defaultInstanceName)
      .iamRole(IamRole.unwrap(iamRole): java.lang.String)
      .optionallyWith(
        registrationLimit.map(value => RegistrationLimit.unwrap(value): Integer)
      )(_.registrationLimit)
      .optionallyWith(
        expirationDate.map(value => ExpirationDate.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        registrationMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.registrationMetadata)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateActivationRequest.ReadOnly =
    zio.aws.ssm.model.CreateActivationRequest.wrap(buildAwsValue())
}
object CreateActivationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateActivationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateActivationRequest =
      zio.aws.ssm.model.CreateActivationRequest(
        description.map(value => value),
        defaultInstanceName.map(value => value),
        iamRole,
        registrationLimit.map(value => value),
        expirationDate.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        registrationMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Optional[ActivationDescription]
    def defaultInstanceName: Optional[DefaultInstanceName]
    def iamRole: IamRole
    def registrationLimit: Optional[RegistrationLimit]
    def expirationDate: Optional[ExpirationDate]
    def tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def registrationMetadata
        : Optional[List[zio.aws.ssm.model.RegistrationMetadataItem.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, ActivationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDefaultInstanceName: ZIO[Any, AwsError, DefaultInstanceName] =
      AwsError.unwrapOptionField("defaultInstanceName", defaultInstanceName)
    def getIamRole: ZIO[Any, Nothing, IamRole] = ZIO.succeed(iamRole)
    def getRegistrationLimit: ZIO[Any, AwsError, RegistrationLimit] =
      AwsError.unwrapOptionField("registrationLimit", registrationLimit)
    def getExpirationDate: ZIO[Any, AwsError, ExpirationDate] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRegistrationMetadata: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.RegistrationMetadataItem.ReadOnly
    ]] =
      AwsError.unwrapOptionField("registrationMetadata", registrationMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateActivationRequest
  ) extends zio.aws.ssm.model.CreateActivationRequest.ReadOnly {
    override val description: Optional[ActivationDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.ssm.model.primitives.ActivationDescription(value))
    override val defaultInstanceName: Optional[DefaultInstanceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultInstanceName())
        .map(value => zio.aws.ssm.model.primitives.DefaultInstanceName(value))
    override val iamRole: IamRole =
      zio.aws.ssm.model.primitives.IamRole(impl.iamRole())
    override val registrationLimit: Optional[RegistrationLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registrationLimit())
        .map(value => zio.aws.ssm.model.primitives.RegistrationLimit(value))
    override val expirationDate: Optional[ExpirationDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expirationDate())
        .map(value => zio.aws.ssm.model.primitives.ExpirationDate(value))
    override val tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Tag.wrap(item)
          }.toList
        )
    override val registrationMetadata
        : Optional[List[zio.aws.ssm.model.RegistrationMetadataItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registrationMetadata())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.RegistrationMetadataItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateActivationRequest
  ): zio.aws.ssm.model.CreateActivationRequest.ReadOnly = new Wrapper(impl)
}
