package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.BaselineId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeletePatchBaselineRequest(baselineId: BaselineId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeletePatchBaselineRequest = {
    import DeletePatchBaselineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeletePatchBaselineRequest
      .builder()
      .baselineId(BaselineId.unwrap(baselineId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeletePatchBaselineRequest.ReadOnly =
    zio.aws.ssm.model.DeletePatchBaselineRequest.wrap(buildAwsValue())
}
object DeletePatchBaselineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeletePatchBaselineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeletePatchBaselineRequest =
      zio.aws.ssm.model.DeletePatchBaselineRequest(baselineId)
    def baselineId: BaselineId
    def getBaselineId: ZIO[Any, Nothing, BaselineId] = ZIO.succeed(baselineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeletePatchBaselineRequest
  ) extends zio.aws.ssm.model.DeletePatchBaselineRequest.ReadOnly {
    override val baselineId: BaselineId =
      zio.aws.ssm.model.primitives.BaselineId(impl.baselineId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeletePatchBaselineRequest
  ): zio.aws.ssm.model.DeletePatchBaselineRequest.ReadOnly = new Wrapper(impl)
}
