package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  NextToken,
  PatchBaselineMaxResults,
  BaselineId
}
import scala.jdk.CollectionConverters.*
final case class DescribeEffectivePatchesForPatchBaselineRequest(
    baselineId: BaselineId,
    maxResults: Optional[PatchBaselineMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest = {
    import DescribeEffectivePatchesForPatchBaselineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
      .builder()
      .baselineId(BaselineId.unwrap(baselineId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => PatchBaselineMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest.ReadOnly =
    zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
      .wrap(buildAwsValue())
}
object DescribeEffectivePatchesForPatchBaselineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest =
      zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest(
        baselineId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def baselineId: BaselineId
    def maxResults: Optional[PatchBaselineMaxResults]
    def nextToken: Optional[NextToken]
    def getBaselineId: ZIO[Any, Nothing, BaselineId] = ZIO.succeed(baselineId)
    def getMaxResults: ZIO[Any, AwsError, PatchBaselineMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
  ) extends zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest.ReadOnly {
    override val baselineId: BaselineId =
      zio.aws.ssm.model.primitives.BaselineId(impl.baselineId())
    override val maxResults: Optional[PatchBaselineMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.PatchBaselineMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
  ): zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest.ReadOnly =
    new Wrapper(impl)
}
