package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait DocumentFilterKey {
  def unwrap: software.amazon.awssdk.services.ssm.model.DocumentFilterKey
}
object DocumentFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.DocumentFilterKey
  ): zio.aws.ssm.model.DocumentFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.DocumentFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.DocumentFilterKey.NAME =>
      val r = Name
      r
    case software.amazon.awssdk.services.ssm.model.DocumentFilterKey.OWNER =>
      val r = Owner
      r
    case software.amazon.awssdk.services.ssm.model.DocumentFilterKey.PLATFORM_TYPES =>
      val r = PlatformTypes
      r
    case software.amazon.awssdk.services.ssm.model.DocumentFilterKey.DOCUMENT_TYPE =>
      val r = DocumentType
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.DocumentFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentFilterKey =
      software.amazon.awssdk.services.ssm.model.DocumentFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object Name extends zio.aws.ssm.model.DocumentFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentFilterKey =
      software.amazon.awssdk.services.ssm.model.DocumentFilterKey.NAME
  }
  case object Owner extends zio.aws.ssm.model.DocumentFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentFilterKey =
      software.amazon.awssdk.services.ssm.model.DocumentFilterKey.OWNER
  }
  case object PlatformTypes extends zio.aws.ssm.model.DocumentFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentFilterKey =
      software.amazon.awssdk.services.ssm.model.DocumentFilterKey.PLATFORM_TYPES
  }
  case object DocumentType extends zio.aws.ssm.model.DocumentFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentFilterKey =
      software.amazon.awssdk.services.ssm.model.DocumentFilterKey.DOCUMENT_TYPE
  }
}
