package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait DocumentPermissionType {
  def unwrap: software.amazon.awssdk.services.ssm.model.DocumentPermissionType
}
object DocumentPermissionType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.DocumentPermissionType
  ): zio.aws.ssm.model.DocumentPermissionType = value match {
    case software.amazon.awssdk.services.ssm.model.DocumentPermissionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.DocumentPermissionType.SHARE =>
      val r = Share
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.DocumentPermissionType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentPermissionType =
      software.amazon.awssdk.services.ssm.model.DocumentPermissionType.UNKNOWN_TO_SDK_VERSION
  }
  case object Share extends zio.aws.ssm.model.DocumentPermissionType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentPermissionType =
      software.amazon.awssdk.services.ssm.model.DocumentPermissionType.SHARE
  }
}
