package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAutomationExecutionResponse(
    automationExecution: Optional[zio.aws.ssm.model.AutomationExecution] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetAutomationExecutionResponse = {
    import GetAutomationExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetAutomationExecutionResponse
      .builder()
      .optionallyWith(automationExecution.map(value => value.buildAwsValue()))(
        _.automationExecution
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetAutomationExecutionResponse.ReadOnly =
    zio.aws.ssm.model.GetAutomationExecutionResponse.wrap(buildAwsValue())
}
object GetAutomationExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetAutomationExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetAutomationExecutionResponse =
      zio.aws.ssm.model.GetAutomationExecutionResponse(
        automationExecution.map(value => value.asEditable)
      )
    def automationExecution
        : Optional[zio.aws.ssm.model.AutomationExecution.ReadOnly]
    def getAutomationExecution
        : ZIO[Any, AwsError, zio.aws.ssm.model.AutomationExecution.ReadOnly] =
      AwsError.unwrapOptionField("automationExecution", automationExecution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetAutomationExecutionResponse
  ) extends zio.aws.ssm.model.GetAutomationExecutionResponse.ReadOnly {
    override val automationExecution
        : Optional[zio.aws.ssm.model.AutomationExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automationExecution())
        .map(value => zio.aws.ssm.model.AutomationExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetAutomationExecutionResponse
  ): zio.aws.ssm.model.GetAutomationExecutionResponse.ReadOnly = new Wrapper(
    impl
  )
}
