package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetResourcePoliciesResponse(
    nextToken: Optional[String] = Optional.Absent,
    policies: Optional[
      Iterable[zio.aws.ssm.model.GetResourcePoliciesResponseEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponse = {
    import GetResourcePoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        policies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policies)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetResourcePoliciesResponse.ReadOnly =
    zio.aws.ssm.model.GetResourcePoliciesResponse.wrap(buildAwsValue())
}
object GetResourcePoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetResourcePoliciesResponse =
      zio.aws.ssm.model.GetResourcePoliciesResponse(
        nextToken.map(value => value),
        policies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def policies: Optional[
      List[zio.aws.ssm.model.GetResourcePoliciesResponseEntry.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPolicies: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.GetResourcePoliciesResponseEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("policies", policies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponse
  ) extends zio.aws.ssm.model.GetResourcePoliciesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val policies: Optional[
      List[zio.aws.ssm.model.GetResourcePoliciesResponseEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.policies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.GetResourcePoliciesResponseEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponse
  ): zio.aws.ssm.model.GetResourcePoliciesResponse.ReadOnly = new Wrapper(impl)
}
