package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InstanceAssociationOutputUrl(
    s3OutputUrl: Optional[zio.aws.ssm.model.S3OutputUrl] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputUrl = {
    import InstanceAssociationOutputUrl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputUrl
      .builder()
      .optionallyWith(s3OutputUrl.map(value => value.buildAwsValue()))(
        _.s3OutputUrl
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstanceAssociationOutputUrl.ReadOnly =
    zio.aws.ssm.model.InstanceAssociationOutputUrl.wrap(buildAwsValue())
}
object InstanceAssociationOutputUrl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputUrl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstanceAssociationOutputUrl =
      zio.aws.ssm.model.InstanceAssociationOutputUrl(
        s3OutputUrl.map(value => value.asEditable)
      )
    def s3OutputUrl: Optional[zio.aws.ssm.model.S3OutputUrl.ReadOnly]
    def getS3OutputUrl
        : ZIO[Any, AwsError, zio.aws.ssm.model.S3OutputUrl.ReadOnly] =
      AwsError.unwrapOptionField("s3OutputUrl", s3OutputUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputUrl
  ) extends zio.aws.ssm.model.InstanceAssociationOutputUrl.ReadOnly {
    override val s3OutputUrl: Optional[zio.aws.ssm.model.S3OutputUrl.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3OutputUrl())
        .map(value => zio.aws.ssm.model.S3OutputUrl.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputUrl
  ): zio.aws.ssm.model.InstanceAssociationOutputUrl.ReadOnly = new Wrapper(impl)
}
