package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait InstanceInformationFilterKey {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey
}
object InstanceInformationFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey
  ): zio.aws.ssm.model.InstanceInformationFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.INSTANCE_IDS =>
      val r = InstanceIds
      r
    case software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.AGENT_VERSION =>
      val r = AgentVersion
      r
    case software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.PING_STATUS =>
      val r = PingStatus
      r
    case software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.PLATFORM_TYPES =>
      val r = PlatformTypes
      r
    case software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.ACTIVATION_IDS =>
      val r = ActivationIds
      r
    case software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.IAM_ROLE =>
      val r = IamRole
      r
    case software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.RESOURCE_TYPE =>
      val r = ResourceType
      r
    case software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.ASSOCIATION_STATUS =>
      val r = AssociationStatus
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.InstanceInformationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey =
      software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object InstanceIds
      extends zio.aws.ssm.model.InstanceInformationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey =
      software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.INSTANCE_IDS
  }
  case object AgentVersion
      extends zio.aws.ssm.model.InstanceInformationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey =
      software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.AGENT_VERSION
  }
  case object PingStatus
      extends zio.aws.ssm.model.InstanceInformationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey =
      software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.PING_STATUS
  }
  case object PlatformTypes
      extends zio.aws.ssm.model.InstanceInformationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey =
      software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.PLATFORM_TYPES
  }
  case object ActivationIds
      extends zio.aws.ssm.model.InstanceInformationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey =
      software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.ACTIVATION_IDS
  }
  case object IamRole extends zio.aws.ssm.model.InstanceInformationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey =
      software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.IAM_ROLE
  }
  case object ResourceType
      extends zio.aws.ssm.model.InstanceInformationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey =
      software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.RESOURCE_TYPE
  }
  case object AssociationStatus
      extends zio.aws.ssm.model.InstanceInformationFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey =
      software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey.ASSOCIATION_STATUS
  }
}
