package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  InventoryDeletionLastStatusUpdateTime,
  InventoryDeletionLastStatusMessage,
  InventoryItemTypeName,
  UUID,
  InventoryDeletionStartTime
}
import scala.jdk.CollectionConverters.*
final case class InventoryDeletionStatusItem(
    deletionId: Optional[UUID] = Optional.Absent,
    typeName: Optional[InventoryItemTypeName] = Optional.Absent,
    deletionStartTime: Optional[InventoryDeletionStartTime] = Optional.Absent,
    lastStatus: Optional[zio.aws.ssm.model.InventoryDeletionStatus] =
      Optional.Absent,
    lastStatusMessage: Optional[InventoryDeletionLastStatusMessage] =
      Optional.Absent,
    deletionSummary: Optional[zio.aws.ssm.model.InventoryDeletionSummary] =
      Optional.Absent,
    lastStatusUpdateTime: Optional[InventoryDeletionLastStatusUpdateTime] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InventoryDeletionStatusItem = {
    import InventoryDeletionStatusItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InventoryDeletionStatusItem
      .builder()
      .optionallyWith(
        deletionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.deletionId)
      .optionallyWith(
        typeName.map(value =>
          InventoryItemTypeName.unwrap(value): java.lang.String
        )
      )(_.typeName)
      .optionallyWith(
        deletionStartTime.map(value =>
          InventoryDeletionStartTime.unwrap(value): Instant
        )
      )(_.deletionStartTime)
      .optionallyWith(lastStatus.map(value => value.unwrap))(_.lastStatus)
      .optionallyWith(
        lastStatusMessage.map(value =>
          InventoryDeletionLastStatusMessage.unwrap(value): java.lang.String
        )
      )(_.lastStatusMessage)
      .optionallyWith(deletionSummary.map(value => value.buildAwsValue()))(
        _.deletionSummary
      )
      .optionallyWith(
        lastStatusUpdateTime.map(value =>
          InventoryDeletionLastStatusUpdateTime.unwrap(value): Instant
        )
      )(_.lastStatusUpdateTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InventoryDeletionStatusItem.ReadOnly =
    zio.aws.ssm.model.InventoryDeletionStatusItem.wrap(buildAwsValue())
}
object InventoryDeletionStatusItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InventoryDeletionStatusItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InventoryDeletionStatusItem =
      zio.aws.ssm.model.InventoryDeletionStatusItem(
        deletionId.map(value => value),
        typeName.map(value => value),
        deletionStartTime.map(value => value),
        lastStatus.map(value => value),
        lastStatusMessage.map(value => value),
        deletionSummary.map(value => value.asEditable),
        lastStatusUpdateTime.map(value => value)
      )
    def deletionId: Optional[UUID]
    def typeName: Optional[InventoryItemTypeName]
    def deletionStartTime: Optional[InventoryDeletionStartTime]
    def lastStatus: Optional[zio.aws.ssm.model.InventoryDeletionStatus]
    def lastStatusMessage: Optional[InventoryDeletionLastStatusMessage]
    def deletionSummary
        : Optional[zio.aws.ssm.model.InventoryDeletionSummary.ReadOnly]
    def lastStatusUpdateTime: Optional[InventoryDeletionLastStatusUpdateTime]
    def getDeletionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("deletionId", deletionId)
    def getTypeName: ZIO[Any, AwsError, InventoryItemTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getDeletionStartTime: ZIO[Any, AwsError, InventoryDeletionStartTime] =
      AwsError.unwrapOptionField("deletionStartTime", deletionStartTime)
    def getLastStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.InventoryDeletionStatus] =
      AwsError.unwrapOptionField("lastStatus", lastStatus)
    def getLastStatusMessage
        : ZIO[Any, AwsError, InventoryDeletionLastStatusMessage] =
      AwsError.unwrapOptionField("lastStatusMessage", lastStatusMessage)
    def getDeletionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.InventoryDeletionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("deletionSummary", deletionSummary)
    def getLastStatusUpdateTime
        : ZIO[Any, AwsError, InventoryDeletionLastStatusUpdateTime] =
      AwsError.unwrapOptionField("lastStatusUpdateTime", lastStatusUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InventoryDeletionStatusItem
  ) extends zio.aws.ssm.model.InventoryDeletionStatusItem.ReadOnly {
    override val deletionId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionId())
      .map(value => zio.aws.ssm.model.primitives.UUID(value))
    override val typeName: Optional[InventoryItemTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeName())
        .map(value => zio.aws.ssm.model.primitives.InventoryItemTypeName(value))
    override val deletionStartTime: Optional[InventoryDeletionStartTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionStartTime())
        .map(value =>
          zio.aws.ssm.model.primitives.InventoryDeletionStartTime(value)
        )
    override val lastStatus
        : Optional[zio.aws.ssm.model.InventoryDeletionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastStatus())
        .map(value => zio.aws.ssm.model.InventoryDeletionStatus.wrap(value))
    override val lastStatusMessage
        : Optional[InventoryDeletionLastStatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStatusMessage())
      .map(value =>
        zio.aws.ssm.model.primitives.InventoryDeletionLastStatusMessage(value)
      )
    override val deletionSummary
        : Optional[zio.aws.ssm.model.InventoryDeletionSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionSummary())
        .map(value => zio.aws.ssm.model.InventoryDeletionSummary.wrap(value))
    override val lastStatusUpdateTime
        : Optional[InventoryDeletionLastStatusUpdateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastStatusUpdateTime())
        .map(value =>
          zio.aws.ssm.model.primitives
            .InventoryDeletionLastStatusUpdateTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InventoryDeletionStatusItem
  ): zio.aws.ssm.model.InventoryDeletionStatusItem.ReadOnly = new Wrapper(impl)
}
