package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.InventoryGroupName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InventoryGroup(
    name: InventoryGroupName,
    filters: Iterable[zio.aws.ssm.model.InventoryFilter]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InventoryGroup = {
    import InventoryGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InventoryGroup
      .builder()
      .name(InventoryGroupName.unwrap(name): java.lang.String)
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InventoryGroup.ReadOnly =
    zio.aws.ssm.model.InventoryGroup.wrap(buildAwsValue())
}
object InventoryGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InventoryGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InventoryGroup =
      zio.aws.ssm.model.InventoryGroup(
        name,
        filters.map { item =>
          item.asEditable
        }
      )
    def name: InventoryGroupName
    def filters: List[zio.aws.ssm.model.InventoryFilter.ReadOnly]
    def getName: ZIO[Any, Nothing, InventoryGroupName] = ZIO.succeed(name)
    def getFilters
        : ZIO[Any, Nothing, List[zio.aws.ssm.model.InventoryFilter.ReadOnly]] =
      ZIO.succeed(filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InventoryGroup
  ) extends zio.aws.ssm.model.InventoryGroup.ReadOnly {
    override val name: InventoryGroupName =
      zio.aws.ssm.model.primitives.InventoryGroupName(impl.name())
    override val filters: List[zio.aws.ssm.model.InventoryFilter.ReadOnly] =
      impl
        .filters()
        .asScala
        .map { item =>
          zio.aws.ssm.model.InventoryFilter.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InventoryGroup
  ): zio.aws.ssm.model.InventoryGroup.ReadOnly = new Wrapper(impl)
}
