package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  MaxResults,
  NextToken,
  DocumentVersion,
  DocumentName
}
import scala.jdk.CollectionConverters.*
final case class ListDocumentMetadataHistoryRequest(
    name: DocumentName,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    metadata: zio.aws.ssm.model.DocumentMetadataEnum,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest = {
    import ListDocumentMetadataHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest
      .builder()
      .name(DocumentName.unwrap(name): java.lang.String)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .metadata(metadata.unwrap)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.ListDocumentMetadataHistoryRequest.ReadOnly =
    zio.aws.ssm.model.ListDocumentMetadataHistoryRequest.wrap(buildAwsValue())
}
object ListDocumentMetadataHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListDocumentMetadataHistoryRequest =
      zio.aws.ssm.model.ListDocumentMetadataHistoryRequest(
        name,
        documentVersion.map(value => value),
        metadata,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def name: DocumentName
    def documentVersion: Optional[DocumentVersion]
    def metadata: zio.aws.ssm.model.DocumentMetadataEnum
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getName: ZIO[Any, Nothing, DocumentName] = ZIO.succeed(name)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getMetadata: ZIO[Any, Nothing, zio.aws.ssm.model.DocumentMetadataEnum] =
      ZIO.succeed(metadata)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest
  ) extends zio.aws.ssm.model.ListDocumentMetadataHistoryRequest.ReadOnly {
    override val name: DocumentName =
      zio.aws.ssm.model.primitives.DocumentName(impl.name())
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val metadata: zio.aws.ssm.model.DocumentMetadataEnum =
      zio.aws.ssm.model.DocumentMetadataEnum.wrap(impl.metadata())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest
  ): zio.aws.ssm.model.ListDocumentMetadataHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
