package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  MaxResults,
  NextToken,
  ResourceDataSyncType
}
import scala.jdk.CollectionConverters.*
final case class ListResourceDataSyncRequest(
    syncType: Optional[ResourceDataSyncType] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest = {
    import ListResourceDataSyncRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest
      .builder()
      .optionallyWith(
        syncType.map(value =>
          ResourceDataSyncType.unwrap(value): java.lang.String
        )
      )(_.syncType)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListResourceDataSyncRequest.ReadOnly =
    zio.aws.ssm.model.ListResourceDataSyncRequest.wrap(buildAwsValue())
}
object ListResourceDataSyncRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListResourceDataSyncRequest =
      zio.aws.ssm.model.ListResourceDataSyncRequest(
        syncType.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def syncType: Optional[ResourceDataSyncType]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getSyncType: ZIO[Any, AwsError, ResourceDataSyncType] =
      AwsError.unwrapOptionField("syncType", syncType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest
  ) extends zio.aws.ssm.model.ListResourceDataSyncRequest.ReadOnly {
    override val syncType: Optional[ResourceDataSyncType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.syncType())
        .map(value => zio.aws.ssm.model.primitives.ResourceDataSyncType(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest
  ): zio.aws.ssm.model.ListResourceDataSyncRequest.ReadOnly = new Wrapper(impl)
}
