package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  SharedDocumentVersion,
  AccountId,
  DocumentName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyDocumentPermissionRequest(
    name: DocumentName,
    permissionType: zio.aws.ssm.model.DocumentPermissionType,
    accountIdsToAdd: Optional[Iterable[AccountId]] = Optional.Absent,
    accountIdsToRemove: Optional[Iterable[AccountId]] = Optional.Absent,
    sharedDocumentVersion: Optional[SharedDocumentVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionRequest = {
    import ModifyDocumentPermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionRequest
      .builder()
      .name(DocumentName.unwrap(name): java.lang.String)
      .permissionType(permissionType.unwrap)
      .optionallyWith(
        accountIdsToAdd.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIdsToAdd)
      .optionallyWith(
        accountIdsToRemove.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIdsToRemove)
      .optionallyWith(
        sharedDocumentVersion.map(value =>
          SharedDocumentVersion.unwrap(value): java.lang.String
        )
      )(_.sharedDocumentVersion)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ModifyDocumentPermissionRequest.ReadOnly =
    zio.aws.ssm.model.ModifyDocumentPermissionRequest.wrap(buildAwsValue())
}
object ModifyDocumentPermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ModifyDocumentPermissionRequest =
      zio.aws.ssm.model.ModifyDocumentPermissionRequest(
        name,
        permissionType,
        accountIdsToAdd.map(value => value),
        accountIdsToRemove.map(value => value),
        sharedDocumentVersion.map(value => value)
      )
    def name: DocumentName
    def permissionType: zio.aws.ssm.model.DocumentPermissionType
    def accountIdsToAdd: Optional[List[AccountId]]
    def accountIdsToRemove: Optional[List[AccountId]]
    def sharedDocumentVersion: Optional[SharedDocumentVersion]
    def getName: ZIO[Any, Nothing, DocumentName] = ZIO.succeed(name)
    def getPermissionType
        : ZIO[Any, Nothing, zio.aws.ssm.model.DocumentPermissionType] =
      ZIO.succeed(permissionType)
    def getAccountIdsToAdd: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIdsToAdd", accountIdsToAdd)
    def getAccountIdsToRemove: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIdsToRemove", accountIdsToRemove)
    def getSharedDocumentVersion: ZIO[Any, AwsError, SharedDocumentVersion] =
      AwsError.unwrapOptionField("sharedDocumentVersion", sharedDocumentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionRequest
  ) extends zio.aws.ssm.model.ModifyDocumentPermissionRequest.ReadOnly {
    override val name: DocumentName =
      zio.aws.ssm.model.primitives.DocumentName(impl.name())
    override val permissionType: zio.aws.ssm.model.DocumentPermissionType =
      zio.aws.ssm.model.DocumentPermissionType.wrap(impl.permissionType())
    override val accountIdsToAdd: Optional[List[AccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountIdsToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.AccountId(item)
          }.toList
        )
    override val accountIdsToRemove: Optional[List[AccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountIdsToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.AccountId(item)
          }.toList
        )
    override val sharedDocumentVersion: Optional[SharedDocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sharedDocumentVersion())
        .map(value => zio.aws.ssm.model.primitives.SharedDocumentVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionRequest
  ): zio.aws.ssm.model.ModifyDocumentPermissionRequest.ReadOnly = new Wrapper(
    impl
  )
}
