package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  OpsItemId,
  OpsItemRelatedItemAssociationType,
  OpsItemRelatedItemAssociationResourceType,
  OpsItemRelatedItemAssociationResourceUri,
  DateTime,
  OpsItemRelatedItemAssociationId
}
import scala.jdk.CollectionConverters.*
final case class OpsItemRelatedItemSummary(
    opsItemId: Optional[OpsItemId] = Optional.Absent,
    associationId: Optional[OpsItemRelatedItemAssociationId] = Optional.Absent,
    resourceType: Optional[OpsItemRelatedItemAssociationResourceType] =
      Optional.Absent,
    associationType: Optional[OpsItemRelatedItemAssociationType] =
      Optional.Absent,
    resourceUri: Optional[OpsItemRelatedItemAssociationResourceUri] =
      Optional.Absent,
    createdBy: Optional[zio.aws.ssm.model.OpsItemIdentity] = Optional.Absent,
    createdTime: Optional[DateTime] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.ssm.model.OpsItemIdentity] =
      Optional.Absent,
    lastModifiedTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemSummary = {
    import OpsItemRelatedItemSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemSummary
      .builder()
      .optionallyWith(
        opsItemId.map(value => OpsItemId.unwrap(value): java.lang.String)
      )(_.opsItemId)
      .optionallyWith(
        associationId.map(value =>
          OpsItemRelatedItemAssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        resourceType.map(value =>
          OpsItemRelatedItemAssociationResourceType.unwrap(
            value
          ): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        associationType.map(value =>
          OpsItemRelatedItemAssociationType.unwrap(value): java.lang.String
        )
      )(_.associationType)
      .optionallyWith(
        resourceUri.map(value =>
          OpsItemRelatedItemAssociationResourceUri.unwrap(
            value
          ): java.lang.String
        )
      )(_.resourceUri)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        createdTime.map(value => DateTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsItemRelatedItemSummary.ReadOnly =
    zio.aws.ssm.model.OpsItemRelatedItemSummary.wrap(buildAwsValue())
}
object OpsItemRelatedItemSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsItemRelatedItemSummary =
      zio.aws.ssm.model.OpsItemRelatedItemSummary(
        opsItemId.map(value => value),
        associationId.map(value => value),
        resourceType.map(value => value),
        associationType.map(value => value),
        resourceUri.map(value => value),
        createdBy.map(value => value.asEditable),
        createdTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value)
      )
    def opsItemId: Optional[OpsItemId]
    def associationId: Optional[OpsItemRelatedItemAssociationId]
    def resourceType: Optional[OpsItemRelatedItemAssociationResourceType]
    def associationType: Optional[OpsItemRelatedItemAssociationType]
    def resourceUri: Optional[OpsItemRelatedItemAssociationResourceUri]
    def createdBy: Optional[zio.aws.ssm.model.OpsItemIdentity.ReadOnly]
    def createdTime: Optional[DateTime]
    def lastModifiedBy: Optional[zio.aws.ssm.model.OpsItemIdentity.ReadOnly]
    def lastModifiedTime: Optional[DateTime]
    def getOpsItemId: ZIO[Any, AwsError, OpsItemId] =
      AwsError.unwrapOptionField("opsItemId", opsItemId)
    def getAssociationId: ZIO[Any, AwsError, OpsItemRelatedItemAssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getResourceType
        : ZIO[Any, AwsError, OpsItemRelatedItemAssociationResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getAssociationType
        : ZIO[Any, AwsError, OpsItemRelatedItemAssociationType] =
      AwsError.unwrapOptionField("associationType", associationType)
    def getResourceUri
        : ZIO[Any, AwsError, OpsItemRelatedItemAssociationResourceUri] =
      AwsError.unwrapOptionField("resourceUri", resourceUri)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.ssm.model.OpsItemIdentity.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.ssm.model.OpsItemIdentity.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemSummary
  ) extends zio.aws.ssm.model.OpsItemRelatedItemSummary.ReadOnly {
    override val opsItemId: Optional[OpsItemId] = zio.aws.core.internal
      .optionalFromNullable(impl.opsItemId())
      .map(value => zio.aws.ssm.model.primitives.OpsItemId(value))
    override val associationId: Optional[OpsItemRelatedItemAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationId())
        .map(value =>
          zio.aws.ssm.model.primitives.OpsItemRelatedItemAssociationId(value)
        )
    override val resourceType
        : Optional[OpsItemRelatedItemAssociationResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.ssm.model.primitives
            .OpsItemRelatedItemAssociationResourceType(value)
        )
    override val associationType: Optional[OpsItemRelatedItemAssociationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationType())
        .map(value =>
          zio.aws.ssm.model.primitives.OpsItemRelatedItemAssociationType(value)
        )
    override val resourceUri
        : Optional[OpsItemRelatedItemAssociationResourceUri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceUri())
        .map(value =>
          zio.aws.ssm.model.primitives
            .OpsItemRelatedItemAssociationResourceUri(value)
        )
    override val createdBy
        : Optional[zio.aws.ssm.model.OpsItemIdentity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.ssm.model.OpsItemIdentity.wrap(value))
    override val createdTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastModifiedBy
        : Optional[zio.aws.ssm.model.OpsItemIdentity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.ssm.model.OpsItemIdentity.wrap(value))
    override val lastModifiedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemSummary
  ): zio.aws.ssm.model.OpsItemRelatedItemSummary.ReadOnly = new Wrapper(impl)
}
