package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait ParameterTier {
  def unwrap: software.amazon.awssdk.services.ssm.model.ParameterTier
}
object ParameterTier {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.ParameterTier
  ): zio.aws.ssm.model.ParameterTier = value match {
    case software.amazon.awssdk.services.ssm.model.ParameterTier.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.ParameterTier.STANDARD =>
      val r = Standard
      r
    case software.amazon.awssdk.services.ssm.model.ParameterTier.ADVANCED =>
      val r = Advanced
      r
    case software.amazon.awssdk.services.ssm.model.ParameterTier.INTELLIGENT_TIERING =>
      val r = `Intelligent-Tiering`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.ParameterTier {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ParameterTier =
      software.amazon.awssdk.services.ssm.model.ParameterTier.UNKNOWN_TO_SDK_VERSION
  }
  case object Standard extends zio.aws.ssm.model.ParameterTier {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ParameterTier =
      software.amazon.awssdk.services.ssm.model.ParameterTier.STANDARD
  }
  case object Advanced extends zio.aws.ssm.model.ParameterTier {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ParameterTier =
      software.amazon.awssdk.services.ssm.model.ParameterTier.ADVANCED
  }
  case object `Intelligent-Tiering` extends zio.aws.ssm.model.ParameterTier {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ParameterTier =
      software.amazon.awssdk.services.ssm.model.ParameterTier.INTELLIGENT_TIERING
  }
}
