package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait PatchDeploymentStatus {
  def unwrap: software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus
}
object PatchDeploymentStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus
  ): zio.aws.ssm.model.PatchDeploymentStatus = value match {
    case software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus.APPROVED =>
      val r = APPROVED
      r
    case software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus.PENDING_APPROVAL =>
      val r = PENDING_APPROVAL
      r
    case software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus.EXPLICIT_APPROVED =>
      val r = EXPLICIT_APPROVED
      r
    case software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus.EXPLICIT_REJECTED =>
      val r = EXPLICIT_REJECTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.PatchDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus =
      software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object APPROVED extends zio.aws.ssm.model.PatchDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus =
      software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus.APPROVED
  }
  case object PENDING_APPROVAL extends zio.aws.ssm.model.PatchDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus =
      software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus.PENDING_APPROVAL
  }
  case object EXPLICIT_APPROVED
      extends zio.aws.ssm.model.PatchDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus =
      software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus.EXPLICIT_APPROVED
  }
  case object EXPLICIT_REJECTED
      extends zio.aws.ssm.model.PatchDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus =
      software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus.EXPLICIT_REJECTED
  }
}
