package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PatchFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PatchFilter(
    key: zio.aws.ssm.model.PatchFilterKey,
    values: Iterable[PatchFilterValue]
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.PatchFilter = {
    import PatchFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PatchFilter
      .builder()
      .key(key.unwrap)
      .values(values.map { item =>
        PatchFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PatchFilter.ReadOnly =
    zio.aws.ssm.model.PatchFilter.wrap(buildAwsValue())
}
object PatchFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.PatchFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PatchFilter =
      zio.aws.ssm.model.PatchFilter(key, values)
    def key: zio.aws.ssm.model.PatchFilterKey
    def values: List[PatchFilterValue]
    def getKey: ZIO[Any, Nothing, zio.aws.ssm.model.PatchFilterKey] =
      ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[PatchFilterValue]] =
      ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PatchFilter
  ) extends zio.aws.ssm.model.PatchFilter.ReadOnly {
    override val key: zio.aws.ssm.model.PatchFilterKey =
      zio.aws.ssm.model.PatchFilterKey.wrap(impl.key())
    override val values: List[PatchFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.PatchFilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PatchFilter
  ): zio.aws.ssm.model.PatchFilter.ReadOnly = new Wrapper(impl)
}
