package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PatchGroup
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PatchGroupPatchBaselineMapping(
    patchGroup: Optional[PatchGroup] = Optional.Absent,
    baselineIdentity: Optional[zio.aws.ssm.model.PatchBaselineIdentity] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.PatchGroupPatchBaselineMapping = {
    import PatchGroupPatchBaselineMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PatchGroupPatchBaselineMapping
      .builder()
      .optionallyWith(
        patchGroup.map(value => PatchGroup.unwrap(value): java.lang.String)
      )(_.patchGroup)
      .optionallyWith(baselineIdentity.map(value => value.buildAwsValue()))(
        _.baselineIdentity
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PatchGroupPatchBaselineMapping.ReadOnly =
    zio.aws.ssm.model.PatchGroupPatchBaselineMapping.wrap(buildAwsValue())
}
object PatchGroupPatchBaselineMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.PatchGroupPatchBaselineMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PatchGroupPatchBaselineMapping =
      zio.aws.ssm.model.PatchGroupPatchBaselineMapping(
        patchGroup.map(value => value),
        baselineIdentity.map(value => value.asEditable)
      )
    def patchGroup: Optional[PatchGroup]
    def baselineIdentity
        : Optional[zio.aws.ssm.model.PatchBaselineIdentity.ReadOnly]
    def getPatchGroup: ZIO[Any, AwsError, PatchGroup] =
      AwsError.unwrapOptionField("patchGroup", patchGroup)
    def getBaselineIdentity
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchBaselineIdentity.ReadOnly] =
      AwsError.unwrapOptionField("baselineIdentity", baselineIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PatchGroupPatchBaselineMapping
  ) extends zio.aws.ssm.model.PatchGroupPatchBaselineMapping.ReadOnly {
    override val patchGroup: Optional[PatchGroup] = zio.aws.core.internal
      .optionalFromNullable(impl.patchGroup())
      .map(value => zio.aws.ssm.model.primitives.PatchGroup(value))
    override val baselineIdentity
        : Optional[zio.aws.ssm.model.PatchBaselineIdentity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baselineIdentity())
        .map(value => zio.aws.ssm.model.PatchBaselineIdentity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PatchGroupPatchBaselineMapping
  ): zio.aws.ssm.model.PatchGroupPatchBaselineMapping.ReadOnly = new Wrapper(
    impl
  )
}
