package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait PatchOperationType {
  def unwrap: software.amazon.awssdk.services.ssm.model.PatchOperationType
}
object PatchOperationType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.PatchOperationType
  ): zio.aws.ssm.model.PatchOperationType = value match {
    case software.amazon.awssdk.services.ssm.model.PatchOperationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.PatchOperationType.SCAN =>
      val r = Scan
      r
    case software.amazon.awssdk.services.ssm.model.PatchOperationType.INSTALL =>
      val r = Install
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.PatchOperationType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchOperationType =
      software.amazon.awssdk.services.ssm.model.PatchOperationType.UNKNOWN_TO_SDK_VERSION
  }
  case object Scan extends zio.aws.ssm.model.PatchOperationType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchOperationType =
      software.amazon.awssdk.services.ssm.model.PatchOperationType.SCAN
  }
  case object Install extends zio.aws.ssm.model.PatchOperationType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchOperationType =
      software.amazon.awssdk.services.ssm.model.PatchOperationType.INSTALL
  }
}
