package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutInventoryRequest(
    instanceId: InstanceId,
    items: Iterable[zio.aws.ssm.model.InventoryItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.PutInventoryRequest = {
    import PutInventoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PutInventoryRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PutInventoryRequest.ReadOnly =
    zio.aws.ssm.model.PutInventoryRequest.wrap(buildAwsValue())
}
object PutInventoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.PutInventoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PutInventoryRequest =
      zio.aws.ssm.model.PutInventoryRequest(
        instanceId,
        items.map { item =>
          item.asEditable
        }
      )
    def instanceId: InstanceId
    def items: List[zio.aws.ssm.model.InventoryItem.ReadOnly]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getItems
        : ZIO[Any, Nothing, List[zio.aws.ssm.model.InventoryItem.ReadOnly]] =
      ZIO.succeed(items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PutInventoryRequest
  ) extends zio.aws.ssm.model.PutInventoryRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ssm.model.primitives.InstanceId(impl.instanceId())
    override val items: List[zio.aws.ssm.model.InventoryItem.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.ssm.model.InventoryItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PutInventoryRequest
  ): zio.aws.ssm.model.PutInventoryRequest.ReadOnly = new Wrapper(impl)
}
