package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  PolicyHash,
  PolicyId,
  Policy,
  ResourceArnString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutResourcePolicyRequest(
    resourceArn: ResourceArnString,
    policy: Policy,
    policyId: Optional[PolicyId] = Optional.Absent,
    policyHash: Optional[PolicyHash] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.PutResourcePolicyRequest = {
    import PutResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PutResourcePolicyRequest
      .builder()
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .policy(Policy.unwrap(policy): java.lang.String)
      .optionallyWith(
        policyId.map(value => PolicyId.unwrap(value): java.lang.String)
      )(_.policyId)
      .optionallyWith(
        policyHash.map(value => PolicyHash.unwrap(value): java.lang.String)
      )(_.policyHash)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PutResourcePolicyRequest.ReadOnly =
    zio.aws.ssm.model.PutResourcePolicyRequest.wrap(buildAwsValue())
}
object PutResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.PutResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PutResourcePolicyRequest =
      zio.aws.ssm.model.PutResourcePolicyRequest(
        resourceArn,
        policy,
        policyId.map(value => value),
        policyHash.map(value => value)
      )
    def resourceArn: ResourceArnString
    def policy: Policy
    def policyId: Optional[PolicyId]
    def policyHash: Optional[PolicyHash]
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
    def getPolicy: ZIO[Any, Nothing, Policy] = ZIO.succeed(policy)
    def getPolicyId: ZIO[Any, AwsError, PolicyId] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getPolicyHash: ZIO[Any, AwsError, PolicyHash] =
      AwsError.unwrapOptionField("policyHash", policyHash)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PutResourcePolicyRequest
  ) extends zio.aws.ssm.model.PutResourcePolicyRequest.ReadOnly {
    override val resourceArn: ResourceArnString =
      zio.aws.ssm.model.primitives.ResourceArnString(impl.resourceArn())
    override val policy: Policy =
      zio.aws.ssm.model.primitives.Policy(impl.policy())
    override val policyId: Optional[PolicyId] = zio.aws.core.internal
      .optionalFromNullable(impl.policyId())
      .map(value => zio.aws.ssm.model.primitives.PolicyId(value))
    override val policyHash: Optional[PolicyHash] = zio.aws.core.internal
      .optionalFromNullable(impl.policyHash())
      .map(value => zio.aws.ssm.model.primitives.PolicyHash(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PutResourcePolicyRequest
  ): zio.aws.ssm.model.PutResourcePolicyRequest.ReadOnly = new Wrapper(impl)
}
