package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{PatchGroup, BaselineId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RegisterPatchBaselineForPatchGroupResponse(
    baselineId: Optional[BaselineId] = Optional.Absent,
    patchGroup: Optional[PatchGroup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupResponse = {
    import RegisterPatchBaselineForPatchGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupResponse
      .builder()
      .optionallyWith(
        baselineId.map(value => BaselineId.unwrap(value): java.lang.String)
      )(_.baselineId)
      .optionallyWith(
        patchGroup.map(value => PatchGroup.unwrap(value): java.lang.String)
      )(_.patchGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupResponse.ReadOnly =
    zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupResponse
      .wrap(buildAwsValue())
}
object RegisterPatchBaselineForPatchGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupResponse =
      zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupResponse(
        baselineId.map(value => value),
        patchGroup.map(value => value)
      )
    def baselineId: Optional[BaselineId]
    def patchGroup: Optional[PatchGroup]
    def getBaselineId: ZIO[Any, AwsError, BaselineId] =
      AwsError.unwrapOptionField("baselineId", baselineId)
    def getPatchGroup: ZIO[Any, AwsError, PatchGroup] =
      AwsError.unwrapOptionField("patchGroup", patchGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupResponse
  ) extends zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupResponse.ReadOnly {
    override val baselineId: Optional[BaselineId] = zio.aws.core.internal
      .optionalFromNullable(impl.baselineId())
      .map(value => zio.aws.ssm.model.primitives.BaselineId(value))
    override val patchGroup: Optional[PatchGroup] = zio.aws.core.internal
      .optionalFromNullable(impl.patchGroup())
      .map(value => zio.aws.ssm.model.primitives.PatchGroup(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupResponse
  ): zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupResponse.ReadOnly =
    new Wrapper(impl)
}
