package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.MaintenanceWindowTaskId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RegisterTaskWithMaintenanceWindowResponse(
    windowTaskId: Optional[MaintenanceWindowTaskId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse = {
    import RegisterTaskWithMaintenanceWindowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse
      .builder()
      .optionallyWith(
        windowTaskId.map(value =>
          MaintenanceWindowTaskId.unwrap(value): java.lang.String
        )
      )(_.windowTaskId)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse.ReadOnly =
    zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse
      .wrap(buildAwsValue())
}
object RegisterTaskWithMaintenanceWindowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse =
      zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse(
        windowTaskId.map(value => value)
      )
    def windowTaskId: Optional[MaintenanceWindowTaskId]
    def getWindowTaskId: ZIO[Any, AwsError, MaintenanceWindowTaskId] =
      AwsError.unwrapOptionField("windowTaskId", windowTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse
  ) extends zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse.ReadOnly {
    override val windowTaskId: Optional[MaintenanceWindowTaskId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windowTaskId())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowTaskId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse
  ): zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse.ReadOnly =
    new Wrapper(impl)
}
