package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait SessionFilterKey {
  def unwrap: software.amazon.awssdk.services.ssm.model.SessionFilterKey
}
object SessionFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.SessionFilterKey
  ): zio.aws.ssm.model.SessionFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.SessionFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.SessionFilterKey.INVOKED_AFTER =>
      val r = InvokedAfter
      r
    case software.amazon.awssdk.services.ssm.model.SessionFilterKey.INVOKED_BEFORE =>
      val r = InvokedBefore
      r
    case software.amazon.awssdk.services.ssm.model.SessionFilterKey.TARGET =>
      val r = Target
      r
    case software.amazon.awssdk.services.ssm.model.SessionFilterKey.OWNER =>
      val r = Owner
      r
    case software.amazon.awssdk.services.ssm.model.SessionFilterKey.STATUS =>
      val r = Status
      r
    case software.amazon.awssdk.services.ssm.model.SessionFilterKey.SESSION_ID =>
      val r = SessionId
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.SessionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionFilterKey =
      software.amazon.awssdk.services.ssm.model.SessionFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object InvokedAfter extends zio.aws.ssm.model.SessionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionFilterKey =
      software.amazon.awssdk.services.ssm.model.SessionFilterKey.INVOKED_AFTER
  }
  case object InvokedBefore extends zio.aws.ssm.model.SessionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionFilterKey =
      software.amazon.awssdk.services.ssm.model.SessionFilterKey.INVOKED_BEFORE
  }
  case object Target extends zio.aws.ssm.model.SessionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionFilterKey =
      software.amazon.awssdk.services.ssm.model.SessionFilterKey.TARGET
  }
  case object Owner extends zio.aws.ssm.model.SessionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionFilterKey =
      software.amazon.awssdk.services.ssm.model.SessionFilterKey.OWNER
  }
  case object Status extends zio.aws.ssm.model.SessionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionFilterKey =
      software.amazon.awssdk.services.ssm.model.SessionFilterKey.STATUS
  }
  case object SessionId extends zio.aws.ssm.model.SessionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionFilterKey =
      software.amazon.awssdk.services.ssm.model.SessionFilterKey.SESSION_ID
  }
}
