package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.AutomationExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartChangeRequestExecutionResponse(
    automationExecutionId: Optional[AutomationExecutionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionResponse = {
    import StartChangeRequestExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionResponse
      .builder()
      .optionallyWith(
        automationExecutionId.map(value =>
          AutomationExecutionId.unwrap(value): java.lang.String
        )
      )(_.automationExecutionId)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.StartChangeRequestExecutionResponse.ReadOnly =
    zio.aws.ssm.model.StartChangeRequestExecutionResponse.wrap(buildAwsValue())
}
object StartChangeRequestExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.StartChangeRequestExecutionResponse =
      zio.aws.ssm.model.StartChangeRequestExecutionResponse(
        automationExecutionId.map(value => value)
      )
    def automationExecutionId: Optional[AutomationExecutionId]
    def getAutomationExecutionId: ZIO[Any, AwsError, AutomationExecutionId] =
      AwsError.unwrapOptionField("automationExecutionId", automationExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionResponse
  ) extends zio.aws.ssm.model.StartChangeRequestExecutionResponse.ReadOnly {
    override val automationExecutionId: Optional[AutomationExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automationExecutionId())
        .map(value => zio.aws.ssm.model.primitives.AutomationExecutionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionResponse
  ): zio.aws.ssm.model.StartChangeRequestExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
