package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  ParameterLabel,
  PSParameterVersion,
  PSParameterName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UnlabelParameterVersionRequest(
    name: PSParameterName,
    parameterVersion: PSParameterVersion,
    labels: Iterable[ParameterLabel]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionRequest = {
    import UnlabelParameterVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionRequest
      .builder()
      .name(PSParameterName.unwrap(name): java.lang.String)
      .parameterVersion(
        PSParameterVersion.unwrap(parameterVersion): java.lang.Long
      )
      .labels(labels.map { item =>
        ParameterLabel.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UnlabelParameterVersionRequest.ReadOnly =
    zio.aws.ssm.model.UnlabelParameterVersionRequest.wrap(buildAwsValue())
}
object UnlabelParameterVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UnlabelParameterVersionRequest =
      zio.aws.ssm.model
        .UnlabelParameterVersionRequest(name, parameterVersion, labels)
    def name: PSParameterName
    def parameterVersion: PSParameterVersion
    def labels: List[ParameterLabel]
    def getName: ZIO[Any, Nothing, PSParameterName] = ZIO.succeed(name)
    def getParameterVersion: ZIO[Any, Nothing, PSParameterVersion] =
      ZIO.succeed(parameterVersion)
    def getLabels: ZIO[Any, Nothing, List[ParameterLabel]] = ZIO.succeed(labels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionRequest
  ) extends zio.aws.ssm.model.UnlabelParameterVersionRequest.ReadOnly {
    override val name: PSParameterName =
      zio.aws.ssm.model.primitives.PSParameterName(impl.name())
    override val parameterVersion: PSParameterVersion =
      zio.aws.ssm.model.primitives.PSParameterVersion(impl.parameterVersion())
    override val labels: List[ParameterLabel] = impl
      .labels()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.ParameterLabel(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionRequest
  ): zio.aws.ssm.model.UnlabelParameterVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
