package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  AssociationId,
  StatusName,
  AssociationExecutionId,
  ResourceCountByStatus,
  DateTime,
  AssociationVersion
}
import scala.jdk.CollectionConverters.*
final case class AssociationExecution(
    associationId: Optional[AssociationId] = Optional.Absent,
    associationVersion: Optional[AssociationVersion] = Optional.Absent,
    executionId: Optional[AssociationExecutionId] = Optional.Absent,
    status: Optional[StatusName] = Optional.Absent,
    detailedStatus: Optional[StatusName] = Optional.Absent,
    createdTime: Optional[DateTime] = Optional.Absent,
    lastExecutionDate: Optional[DateTime] = Optional.Absent,
    resourceCountByStatus: Optional[ResourceCountByStatus] = Optional.Absent,
    alarmConfiguration: Optional[zio.aws.ssm.model.AlarmConfiguration] =
      Optional.Absent,
    triggeredAlarms: Optional[
      Iterable[zio.aws.ssm.model.AlarmStateInformation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AssociationExecution = {
    import AssociationExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AssociationExecution
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        associationVersion.map(value =>
          AssociationVersion.unwrap(value): java.lang.String
        )
      )(_.associationVersion)
      .optionallyWith(
        executionId.map(value =>
          AssociationExecutionId.unwrap(value): java.lang.String
        )
      )(_.executionId)
      .optionallyWith(
        status.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        detailedStatus.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.detailedStatus)
      .optionallyWith(
        createdTime.map(value => DateTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        lastExecutionDate.map(value => DateTime.unwrap(value): Instant)
      )(_.lastExecutionDate)
      .optionallyWith(
        resourceCountByStatus.map(value =>
          ResourceCountByStatus.unwrap(value): java.lang.String
        )
      )(_.resourceCountByStatus)
      .optionallyWith(alarmConfiguration.map(value => value.buildAwsValue()))(
        _.alarmConfiguration
      )
      .optionallyWith(
        triggeredAlarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.triggeredAlarms)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AssociationExecution.ReadOnly =
    zio.aws.ssm.model.AssociationExecution.wrap(buildAwsValue())
}
object AssociationExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AssociationExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AssociationExecution =
      zio.aws.ssm.model.AssociationExecution(
        associationId.map(value => value),
        associationVersion.map(value => value),
        executionId.map(value => value),
        status.map(value => value),
        detailedStatus.map(value => value),
        createdTime.map(value => value),
        lastExecutionDate.map(value => value),
        resourceCountByStatus.map(value => value),
        alarmConfiguration.map(value => value.asEditable),
        triggeredAlarms.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def associationId: Optional[AssociationId]
    def associationVersion: Optional[AssociationVersion]
    def executionId: Optional[AssociationExecutionId]
    def status: Optional[StatusName]
    def detailedStatus: Optional[StatusName]
    def createdTime: Optional[DateTime]
    def lastExecutionDate: Optional[DateTime]
    def resourceCountByStatus: Optional[ResourceCountByStatus]
    def alarmConfiguration
        : Optional[zio.aws.ssm.model.AlarmConfiguration.ReadOnly]
    def triggeredAlarms
        : Optional[List[zio.aws.ssm.model.AlarmStateInformation.ReadOnly]]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAssociationVersion: ZIO[Any, AwsError, AssociationVersion] =
      AwsError.unwrapOptionField("associationVersion", associationVersion)
    def getExecutionId: ZIO[Any, AwsError, AssociationExecutionId] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("status", status)
    def getDetailedStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("detailedStatus", detailedStatus)
    def getCreatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastExecutionDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastExecutionDate", lastExecutionDate)
    def getResourceCountByStatus: ZIO[Any, AwsError, ResourceCountByStatus] =
      AwsError.unwrapOptionField("resourceCountByStatus", resourceCountByStatus)
    def getAlarmConfiguration
        : ZIO[Any, AwsError, zio.aws.ssm.model.AlarmConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("alarmConfiguration", alarmConfiguration)
    def getTriggeredAlarms: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AlarmStateInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("triggeredAlarms", triggeredAlarms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AssociationExecution
  ) extends zio.aws.ssm.model.AssociationExecution.ReadOnly {
    override val associationId: Optional[AssociationId] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => zio.aws.ssm.model.primitives.AssociationId(value))
    override val associationVersion: Optional[AssociationVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationVersion())
        .map(value => zio.aws.ssm.model.primitives.AssociationVersion(value))
    override val executionId: Optional[AssociationExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionId())
        .map(value =>
          zio.aws.ssm.model.primitives.AssociationExecutionId(value)
        )
    override val status: Optional[StatusName] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val detailedStatus: Optional[StatusName] = zio.aws.core.internal
      .optionalFromNullable(impl.detailedStatus())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val createdTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastExecutionDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastExecutionDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val resourceCountByStatus: Optional[ResourceCountByStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceCountByStatus())
        .map(value => zio.aws.ssm.model.primitives.ResourceCountByStatus(value))
    override val alarmConfiguration
        : Optional[zio.aws.ssm.model.AlarmConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmConfiguration())
        .map(value => zio.aws.ssm.model.AlarmConfiguration.wrap(value))
    override val triggeredAlarms
        : Optional[List[zio.aws.ssm.model.AlarmStateInformation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.triggeredAlarms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.AlarmStateInformation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AssociationExecution
  ): zio.aws.ssm.model.AssociationExecution.ReadOnly = new Wrapper(impl)
}
