package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait AssociationExecutionFilterKey {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.AssociationExecutionFilterKey
}
object AssociationExecutionFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.AssociationExecutionFilterKey
  ): zio.aws.ssm.model.AssociationExecutionFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.AssociationExecutionFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.AssociationExecutionFilterKey.EXECUTION_ID =>
      val r = ExecutionId
      r
    case software.amazon.awssdk.services.ssm.model.AssociationExecutionFilterKey.STATUS =>
      val r = Status
      r
    case software.amazon.awssdk.services.ssm.model.AssociationExecutionFilterKey.CREATED_TIME =>
      val r = CreatedTime
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.AssociationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationExecutionFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object ExecutionId
      extends zio.aws.ssm.model.AssociationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationExecutionFilterKey.EXECUTION_ID
  }
  case object Status extends zio.aws.ssm.model.AssociationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationExecutionFilterKey.STATUS
  }
  case object CreatedTime
      extends zio.aws.ssm.model.AssociationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationExecutionFilterKey.CREATED_TIME
  }
}
