package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAssociationResponse(
    associationDescription: Optional[zio.aws.ssm.model.AssociationDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateAssociationResponse = {
    import CreateAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateAssociationResponse
      .builder()
      .optionallyWith(
        associationDescription.map(value => value.buildAwsValue())
      )(_.associationDescription)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateAssociationResponse.ReadOnly =
    zio.aws.ssm.model.CreateAssociationResponse.wrap(buildAwsValue())
}
object CreateAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateAssociationResponse =
      zio.aws.ssm.model.CreateAssociationResponse(
        associationDescription.map(value => value.asEditable)
      )
    def associationDescription
        : Optional[zio.aws.ssm.model.AssociationDescription.ReadOnly]
    def getAssociationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.AssociationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "associationDescription",
      associationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateAssociationResponse
  ) extends zio.aws.ssm.model.CreateAssociationResponse.ReadOnly {
    override val associationDescription
        : Optional[zio.aws.ssm.model.AssociationDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationDescription())
        .map(value => zio.aws.ssm.model.AssociationDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateAssociationResponse
  ): zio.aws.ssm.model.CreateAssociationResponse.ReadOnly = new Wrapper(impl)
}
