package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentDisplayName,
  DocumentName,
  DocumentContent,
  DocumentVersionName,
  TargetType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDocumentRequest(
    content: DocumentContent,
    requires: Optional[Iterable[zio.aws.ssm.model.DocumentRequires]] =
      Optional.Absent,
    attachments: Optional[Iterable[zio.aws.ssm.model.AttachmentsSource]] =
      Optional.Absent,
    name: DocumentName,
    displayName: Optional[DocumentDisplayName] = Optional.Absent,
    versionName: Optional[DocumentVersionName] = Optional.Absent,
    documentType: Optional[zio.aws.ssm.model.DocumentType] = Optional.Absent,
    documentFormat: Optional[zio.aws.ssm.model.DocumentFormat] =
      Optional.Absent,
    targetType: Optional[TargetType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ssm.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateDocumentRequest = {
    import CreateDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateDocumentRequest
      .builder()
      .content(DocumentContent.unwrap(content): java.lang.String)
      .optionallyWith(
        requires.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requires)
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .name(DocumentName.unwrap(name): java.lang.String)
      .optionallyWith(
        displayName.map(value =>
          DocumentDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        versionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .optionallyWith(documentType.map(value => value.unwrap))(_.documentType)
      .optionallyWith(documentFormat.map(value => value.unwrap))(
        _.documentFormat
      )
      .optionallyWith(
        targetType.map(value => TargetType.unwrap(value): java.lang.String)
      )(_.targetType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateDocumentRequest.ReadOnly =
    zio.aws.ssm.model.CreateDocumentRequest.wrap(buildAwsValue())
}
object CreateDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateDocumentRequest =
      zio.aws.ssm.model.CreateDocumentRequest(
        content,
        requires.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name,
        displayName.map(value => value),
        versionName.map(value => value),
        documentType.map(value => value),
        documentFormat.map(value => value),
        targetType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def content: DocumentContent
    def requires: Optional[List[zio.aws.ssm.model.DocumentRequires.ReadOnly]]
    def attachments
        : Optional[List[zio.aws.ssm.model.AttachmentsSource.ReadOnly]]
    def name: DocumentName
    def displayName: Optional[DocumentDisplayName]
    def versionName: Optional[DocumentVersionName]
    def documentType: Optional[zio.aws.ssm.model.DocumentType]
    def documentFormat: Optional[zio.aws.ssm.model.DocumentFormat]
    def targetType: Optional[TargetType]
    def tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def getContent: ZIO[Any, Nothing, DocumentContent] = ZIO.succeed(content)
    def getRequires: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentRequires.ReadOnly
    ]] = AwsError.unwrapOptionField("requires", requires)
    def getAttachments: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AttachmentsSource.ReadOnly
    ]] = AwsError.unwrapOptionField("attachments", attachments)
    def getName: ZIO[Any, Nothing, DocumentName] = ZIO.succeed(name)
    def getDisplayName: ZIO[Any, AwsError, DocumentDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getDocumentType: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentType] =
      AwsError.unwrapOptionField("documentType", documentType)
    def getDocumentFormat
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentFormat] =
      AwsError.unwrapOptionField("documentFormat", documentFormat)
    def getTargetType: ZIO[Any, AwsError, TargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateDocumentRequest
  ) extends zio.aws.ssm.model.CreateDocumentRequest.ReadOnly {
    override val content: DocumentContent =
      zio.aws.ssm.model.primitives.DocumentContent(impl.content())
    override val requires
        : Optional[List[zio.aws.ssm.model.DocumentRequires.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requires())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.DocumentRequires.wrap(item)
          }.toList
        )
    override val attachments
        : Optional[List[zio.aws.ssm.model.AttachmentsSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.AttachmentsSource.wrap(item)
          }.toList
        )
    override val name: DocumentName =
      zio.aws.ssm.model.primitives.DocumentName(impl.name())
    override val displayName: Optional[DocumentDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value => zio.aws.ssm.model.primitives.DocumentDisplayName(value))
    override val versionName: Optional[DocumentVersionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionName())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
    override val documentType: Optional[zio.aws.ssm.model.DocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentType())
        .map(value => zio.aws.ssm.model.DocumentType.wrap(value))
    override val documentFormat: Optional[zio.aws.ssm.model.DocumentFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentFormat())
        .map(value => zio.aws.ssm.model.DocumentFormat.wrap(value))
    override val targetType: Optional[TargetType] = zio.aws.core.internal
      .optionalFromNullable(impl.targetType())
      .map(value => zio.aws.ssm.model.primitives.TargetType(value))
    override val tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateDocumentRequest
  ): zio.aws.ssm.model.CreateDocumentRequest.ReadOnly = new Wrapper(impl)
}
