package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.OpsItemId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteOpsItemRequest(opsItemId: OpsItemId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeleteOpsItemRequest = {
    import DeleteOpsItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeleteOpsItemRequest
      .builder()
      .opsItemId(OpsItemId.unwrap(opsItemId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeleteOpsItemRequest.ReadOnly =
    zio.aws.ssm.model.DeleteOpsItemRequest.wrap(buildAwsValue())
}
object DeleteOpsItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeleteOpsItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeleteOpsItemRequest =
      zio.aws.ssm.model.DeleteOpsItemRequest(opsItemId)
    def opsItemId: OpsItemId
    def getOpsItemId: ZIO[Any, Nothing, OpsItemId] = ZIO.succeed(opsItemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeleteOpsItemRequest
  ) extends zio.aws.ssm.model.DeleteOpsItemRequest.ReadOnly {
    override val opsItemId: OpsItemId =
      zio.aws.ssm.model.primitives.OpsItemId(impl.opsItemId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeleteOpsItemRequest
  ): zio.aws.ssm.model.DeleteOpsItemRequest.ReadOnly = new Wrapper(impl)
}
