package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  NextToken,
  MaxResults,
  AssociationExecutionId,
  AssociationId
}
import scala.jdk.CollectionConverters.*
final case class DescribeAssociationExecutionTargetsRequest(
    associationId: AssociationId,
    executionId: AssociationExecutionId,
    filters: Optional[
      Iterable[zio.aws.ssm.model.AssociationExecutionTargetsFilter]
    ] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest = {
    import DescribeAssociationExecutionTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest
      .builder()
      .associationId(AssociationId.unwrap(associationId): java.lang.String)
      .executionId(AssociationExecutionId.unwrap(executionId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeAssociationExecutionTargetsRequest.ReadOnly =
    zio.aws.ssm.model.DescribeAssociationExecutionTargetsRequest
      .wrap(buildAwsValue())
}
object DescribeAssociationExecutionTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeAssociationExecutionTargetsRequest =
      zio.aws.ssm.model.DescribeAssociationExecutionTargetsRequest(
        associationId,
        executionId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def associationId: AssociationId
    def executionId: AssociationExecutionId
    def filters: Optional[
      List[zio.aws.ssm.model.AssociationExecutionTargetsFilter.ReadOnly]
    ]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getAssociationId: ZIO[Any, Nothing, AssociationId] =
      ZIO.succeed(associationId)
    def getExecutionId: ZIO[Any, Nothing, AssociationExecutionId] =
      ZIO.succeed(executionId)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AssociationExecutionTargetsFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest
  ) extends zio.aws.ssm.model.DescribeAssociationExecutionTargetsRequest.ReadOnly {
    override val associationId: AssociationId =
      zio.aws.ssm.model.primitives.AssociationId(impl.associationId())
    override val executionId: AssociationExecutionId =
      zio.aws.ssm.model.primitives.AssociationExecutionId(impl.executionId())
    override val filters: Optional[
      List[zio.aws.ssm.model.AssociationExecutionTargetsFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.AssociationExecutionTargetsFilter.wrap(item)
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest
  ): zio.aws.ssm.model.DescribeAssociationExecutionTargetsRequest.ReadOnly =
    new Wrapper(impl)
}
