package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{NextToken, AccountId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDocumentPermissionResponse(
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent,
    accountSharingInfoList: Optional[
      Iterable[zio.aws.ssm.model.AccountSharingInfo]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse = {
    import DescribeDocumentPermissionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        accountSharingInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountSharingInfoList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeDocumentPermissionResponse.ReadOnly =
    zio.aws.ssm.model.DescribeDocumentPermissionResponse.wrap(buildAwsValue())
}
object DescribeDocumentPermissionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeDocumentPermissionResponse =
      zio.aws.ssm.model.DescribeDocumentPermissionResponse(
        accountIds.map(value => value),
        accountSharingInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accountIds: Optional[List[AccountId]]
    def accountSharingInfoList
        : Optional[List[zio.aws.ssm.model.AccountSharingInfo.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getAccountSharingInfoList: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AccountSharingInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "accountSharingInfoList",
      accountSharingInfoList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse
  ) extends zio.aws.ssm.model.DescribeDocumentPermissionResponse.ReadOnly {
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.AccountId(item)
        }.toList
      )
    override val accountSharingInfoList
        : Optional[List[zio.aws.ssm.model.AccountSharingInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountSharingInfoList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.AccountSharingInfo.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse
  ): zio.aws.ssm.model.DescribeDocumentPermissionResponse.ReadOnly =
    new Wrapper(impl)
}
