package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{NextToken, MaxResultsEC2Compatible}
import scala.jdk.CollectionConverters.*
final case class DescribeInstanceInformationRequest(
    instanceInformationFilterList: Optional[
      Iterable[zio.aws.ssm.model.InstanceInformationFilter]
    ] = Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.ssm.model.InstanceInformationStringFilter]
    ] = Optional.Absent,
    maxResults: Optional[MaxResultsEC2Compatible] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest = {
    import DescribeInstanceInformationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest
      .builder()
      .optionallyWith(
        instanceInformationFilterList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceInformationFilterList)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResultsEC2Compatible.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeInstanceInformationRequest.ReadOnly =
    zio.aws.ssm.model.DescribeInstanceInformationRequest.wrap(buildAwsValue())
}
object DescribeInstanceInformationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeInstanceInformationRequest =
      zio.aws.ssm.model.DescribeInstanceInformationRequest(
        instanceInformationFilterList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceInformationFilterList
        : Optional[List[zio.aws.ssm.model.InstanceInformationFilter.ReadOnly]]
    def filters: Optional[
      List[zio.aws.ssm.model.InstanceInformationStringFilter.ReadOnly]
    ]
    def maxResults: Optional[MaxResultsEC2Compatible]
    def nextToken: Optional[NextToken]
    def getInstanceInformationFilterList: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InstanceInformationFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "instanceInformationFilterList",
      instanceInformationFilterList
    )
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InstanceInformationStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsEC2Compatible] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest
  ) extends zio.aws.ssm.model.DescribeInstanceInformationRequest.ReadOnly {
    override val instanceInformationFilterList
        : Optional[List[zio.aws.ssm.model.InstanceInformationFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceInformationFilterList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.InstanceInformationFilter.wrap(item)
          }.toList
        )
    override val filters: Optional[
      List[zio.aws.ssm.model.InstanceInformationStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.InstanceInformationStringFilter.wrap(item)
        }.toList
      )
    override val maxResults: Optional[MaxResultsEC2Compatible] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.MaxResultsEC2Compatible(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest
  ): zio.aws.ssm.model.DescribeInstanceInformationRequest.ReadOnly =
    new Wrapper(impl)
}
